/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.relational;

public class PhysicalMetaDataToXML {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2006";
    public static final String PHYSICAL_SCHEMA = "physicalSchema";
    public static final String HOST_MACHINE = "hostMachine";
    public static final String DATABASE = "database";
    public static final String HOST_MACHINE_VALUE = "hostMachineValue";
    public static final String MAX_JOIN_SIZE = "max_join_size";
    public static final String JOIN_BUFFER_SIZE = "join_buffer_size";
    public static final String NAME = "name";
    public static final String ROW_FORMAT = "rowFormat";
    public static final String ROWS = "rows";
    public static final String AVG_ROW_LENGTH = "avgRowLength";
    public static final String DATA_LENGTH = "dataLength";
    public static final String INDEX_LENGTH = "indexLength";
    public static final String DQP_NS = "http://uk.org.ogsadai/dqp/importedschemas";

    public static void writeHeader(StringBuffer output, String hostIP, String databaseName, String maxJoinSize, String joinBufferSize) {
        output.append("<");
        output.append(PHYSICAL_SCHEMA);
        output.append(" xmlns=\"");
        output.append(DQP_NS);
        output.append("\">\n");
        output.append("<");
        output.append(HOST_MACHINE);
        output.append("><");
        output.append(HOST_MACHINE_VALUE);
        output.append(">");
        output.append(hostIP);
        output.append("</");
        output.append(HOST_MACHINE_VALUE);
        output.append("></");
        output.append(HOST_MACHINE);
        output.append(">\n");
        output.append("<");
        output.append(DATABASE);
        output.append(" name=\"");
        output.append(databaseName);
        output.append("\" ");
        if (maxJoinSize != null) {
            output.append(MAX_JOIN_SIZE);
            output.append("=\"");
            output.append(maxJoinSize);
            output.append("\" ");
        }
        if (joinBufferSize != null) {
            output.append(JOIN_BUFFER_SIZE);
            output.append("=\"");
            output.append(joinBufferSize);
            output.append("\" ");
        }
        output.append(">\n");
    }

    public static void writeTable(StringBuffer output, String tableName, String rowFormat, String rows, String avgRowLength, String dataLength, String indexLength) {
        output.append("<physTable ");
        output.append(NAME);
        output.append("=\"");
        output.append(tableName);
        output.append("\" ");
        if (rowFormat != null) {
            output.append(ROW_FORMAT);
            output.append("=\"");
            output.append(rowFormat);
            output.append("\" ");
        }
        if (rows != null) {
            output.append(ROWS);
            output.append("=\"");
            output.append(rows);
            output.append("\" ");
        }
        if (avgRowLength != null) {
            output.append(AVG_ROW_LENGTH);
            output.append("=\"");
            output.append(avgRowLength);
            output.append("\" ");
        }
        if (dataLength != null) {
            output.append(DATA_LENGTH);
            output.append("=\"");
            output.append(dataLength);
            output.append("\" ");
        }
        if (indexLength != null) {
            output.append(INDEX_LENGTH);
            output.append("=\"");
            output.append(indexLength);
            output.append("\"");
        }
        output.append("/>\n");
    }

    public static void writeFooter(StringBuffer output) {
        output.append("</");
        output.append(DATABASE);
        output.append(">\n");
        output.append("</");
        output.append(PHYSICAL_SCHEMA);
        output.append(">\n");
    }
}

