/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.relational;

import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.relational.PhysicalMetaDataToXML;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.NetUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.dataresource.JDBCConnectionProvider;
import uk.org.ogsadai.dataresource.JDBCConnectionUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIUnknownHostException;

public class MySQLExtractPhysicalSchemaActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)MySQLExtractPhysicalSchemaActivity.class);
    private JDBCConnectionProvider mDataResource;
    private Connection mConnection;
    private String mCredentials;
    private BlockWriter mOutput;
    private ResultSet mTableInfo;
    private String mTablePattern;
    public static final String MAX_JOIN_SIZE = "max_join_size";
    public static final String JOIN_BUFFER_SIZE = "join_buffer_size";

    public MySQLExtractPhysicalSchemaActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        Element getTables;
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        String outputName = output.getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "getTables");
        if (nodelist != null && nodelist.getLength() > 0 && (getTables = (Element)nodelist.item(0)).hasAttribute("name")) {
            this.mTablePattern = getTables.getAttribute("name");
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        this.mDataResource = (JDBCConnectionProvider)this.mContext.getDataResourceAccessor();
        this.mCredentials = this.mContext.getSecurityContext().getDN();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void processFirst() {
        try {
            this.mConnection = this.mDataResource.getJDBCConnection(this.mCredentials);
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DAIAuthorizationException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e)));
            return;
        }
        catch (AuthorizationExecutionException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DataResourceUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        try {
            Statement statement = this.mConnection.createStatement();
            StringBuffer schema = new StringBuffer();
            String maxJoinSize = null;
            String joinBufferSize = null;
            ResultSet variables = statement.executeQuery("show variables");
            variables.beforeFirst();
            while (variables.next()) {
                String name = variables.getString("Variable_name");
                if (name.equals(MAX_JOIN_SIZE)) {
                    maxJoinSize = variables.getString("Value");
                }
                if (!name.equals(JOIN_BUFFER_SIZE)) continue;
                joinBufferSize = variables.getString("Value");
            }
            PhysicalMetaDataToXML.writeHeader(schema, NetUtilities.getMachineIPAddress(), this.getDatabaseName(this.mConnection), maxJoinSize, joinBufferSize);
            this.mOutput.put((Object)schema.toString());
            String pattern = this.mTablePattern == null ? "" : " like '" + this.mTablePattern + "'";
            this.mTableInfo = statement.executeQuery("show table status" + pattern);
            this.mTableInfo.beforeFirst();
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (UnknownHostException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIUnknownHostException(e)));
            return;
        }
    }

    protected void processBlock() {
        StringBuffer schema = new StringBuffer();
        try {
            if (this.mTableInfo.next()) {
                PhysicalMetaDataToXML.writeTable(schema, this.mTableInfo.getString("Name"), this.mTableInfo.getString("Row_format"), this.mTableInfo.getString("Rows"), this.mTableInfo.getString("Avg_row_length"), this.mTableInfo.getString("Data_length"), this.mTableInfo.getString("Index_length"));
                this.mOutput.put((Object)schema.toString());
            } else {
                PhysicalMetaDataToXML.writeFooter(schema);
                this.mOutput.put((Object)schema.toString());
                this.mOutput.close();
                this.mDataResource.releaseJDBCConnection(this.mConnection);
                this.mOutput = null;
                this.mConnection = null;
                this.setCompleted();
            }
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
    }

    protected void cleanUp() {
        if (this.mConnection != null) {
            try {
                this.mDataResource.releaseJDBCConnection(this.mConnection);
                this.mConnection = null;
            }
            catch (JDBCConnectionUseException e) {
                LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)e));
                return;
            }
        }
        if (this.mOutput != null) {
            this.mOutput.close();
            this.mOutput = null;
        }
    }

    private String getDatabaseName(Connection connection) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String dburlstr = metadata.getURL();
        dburlstr = dburlstr.substring(dburlstr.indexOf("//") + 2);
        String dbname = dburlstr.substring(dburlstr.indexOf("/") + 1);
        return dbname;
    }
}

