/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.relational;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.converters.databaseschema.ResultSetTableMetaDataException;
import uk.org.ogsadai.converters.databaseschema.toxml.TableMetaDataImpl;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.dataresource.JDBCConnectionProvider;
import uk.org.ogsadai.dataresource.JDBCConnectionUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public class ExtractDatabaseSchemaActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)ExtractDatabaseSchemaActivity.class);
    private JDBCConnectionProvider mDataResource;
    private Connection mConnection;
    private String mCredentials;
    private BlockWriter mOutput;
    private DatabaseMetaData mMetaData;
    private String mCatalog = null;
    private String mSchemaPattern = null;
    private String mCurrentSchema;
    private String mTablePattern = null;
    private ResultSet mSchemas;
    private ResultSet mTables;
    private boolean mTableNamesOnly = false;

    public ExtractDatabaseSchemaActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        String outputName = output.getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "getTables");
        if (nodelist != null && nodelist.getLength() > 0) {
            Element getTables = (Element)nodelist.item(0);
            if (getTables.hasAttribute("catalogName")) {
                this.mCatalog = getTables.getAttribute("catalogName");
            }
            if (getTables.hasAttribute("schemaNamePattern")) {
                this.mSchemaPattern = getTables.getAttribute("schemaNamePattern");
            }
            if (getTables.hasAttribute("tableNamePattern")) {
                this.mTablePattern = getTables.getAttribute("tableNamePattern");
            }
            if (getTables.hasAttribute("namesOnly")) {
                this.mTableNamesOnly = new Boolean(getTables.getAttribute("namesOnly"));
            }
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        this.mDataResource = (JDBCConnectionProvider)this.mContext.getDataResourceAccessor();
        this.mCredentials = this.mContext.getSecurityContext().getDN();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void processFirst() {
        try {
            this.mConnection = this.mDataResource.getJDBCConnection(this.mCredentials);
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DAIAuthorizationException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e)));
            return;
        }
        catch (AuthorizationExecutionException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DataResourceUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        try {
            this.mMetaData = this.mConnection.getMetaData();
            if (this.mCatalog == null) {
                this.mCatalog = this.mConnection.getCatalog();
            }
            if (this.mSchemaPattern == null) {
                this.mSchemas = this.mMetaData.getSchemas();
                if (this.mSchemas.next()) {
                    this.mCurrentSchema = this.mSchemas.getString(1);
                }
            } else {
                this.mSchemas = null;
                this.mCurrentSchema = this.mSchemaPattern;
            }
            if (this.mTablePattern == null) {
                this.mTablePattern = "%";
            }
            this.mTables = this.mMetaData.getTables(this.mCatalog, this.mCurrentSchema, this.mTablePattern, null);
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
    }

    protected void processBlock() {
        try {
            if (this.mTables.next()) {
                String tableName = this.mTables.getString("TABLE_NAME");
                TableMetaDataImpl table = new TableMetaDataImpl(this.mCatalog, this.mCurrentSchema, tableName);
                if (!this.mTableNamesOnly) {
                    table.setColumns(this.mMetaData.getColumns(this.mCatalog, this.mCurrentSchema, tableName, null));
                    table.setPrimaryKeys(this.mMetaData.getPrimaryKeys(this.mCatalog, this.mCurrentSchema, tableName));
                    table.setImportedKeys(this.mMetaData.getImportedKeys(this.mCatalog, this.mCurrentSchema, tableName));
                    table.setExportedKeys(this.mMetaData.getExportedKeys(this.mCatalog, this.mCurrentSchema, tableName));
                }
                this.mOutput.put((Object)table);
            } else if (this.mSchemas != null && this.mSchemas.next()) {
                this.mCurrentSchema = this.mSchemas.getString(1);
                this.mTables = this.mMetaData.getTables(this.mCatalog, this.mCurrentSchema, this.mTablePattern, null);
            } else {
                this.setCompleted();
            }
        }
        catch (ResultSetTableMetaDataException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
    }

    protected void cleanUp() {
        if (this.mConnection != null) {
            try {
                this.mDataResource.releaseJDBCConnection(this.mConnection);
            }
            catch (JDBCConnectionUseException e) {
                LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)e));
                return;
            }
        }
    }
}

