/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.relational;

import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;
import uk.org.ogsadai.converters.databaseschema.toxml.SchemaConverter;
import uk.org.ogsadai.converters.databaseschema.toxml.SchemaToXMLConverter;

public class DatabaseSchemaToXMLActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)DatabaseSchemaToXMLActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;
    private SchemaConverter mConverter;

    public DatabaseSchemaToXMLActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        Element input = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "schema").item(0);
        String inputName = input.getAttribute("from");
        this.mInternalInputs = new String[]{inputName};
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        String outputName = output.getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.mConverter = new SchemaToXMLConverter();
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void processFirst() {
        StringBuffer header = new StringBuffer();
        this.mConverter.writeHeader(header);
        this.mOutput.put((Object)header.toString());
    }

    protected void processBlock() {
        if (this.mInput.hasNext()) {
            Object block = this.mInput.next();
            if (block instanceof TableMetaData) {
                TableMetaData table = (TableMetaData)block;
                StringBuffer schema = new StringBuffer();
                this.mConverter.writeTable(schema, table);
                this.mOutput.put((Object)schema.toString());
            }
        } else {
            StringBuffer footer = new StringBuffer();
            this.mConverter.writeFooter(footer);
            this.mOutput.put((Object)footer.toString());
            this.setCompleted();
        }
    }

    protected void cleanUp() {
        if (this.mOutput != null) {
            this.mOutput.close();
        }
    }
}

