/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.misc;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;

public class NotificationActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)NotificationActivity.class);
    private static final int NONE = 0;
    private static final int COMMENCED = 1;
    private static final int COMPLETE = 2;
    private int mNotifyType;
    private String mMessage;
    private BlockReader mDataInput;
    private BlockWriter mDataOutput;
    private BlockWriter mNotificationOutput;

    public NotificationActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList notifyList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "notify");
        NodeList dataInputList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "dataInput");
        NodeList dataOutputList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "dataOutput");
        NodeList notificationOutputList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "notificationOutput");
        NodeList messageList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "message");
        NamedNodeMap notifyTypeAttributes = notifyList.item(0).getAttributes();
        String notifyType = notifyTypeAttributes.getNamedItem("type").getNodeValue();
        NamedNodeMap dataInputAttributes = dataInputList.item(0).getAttributes();
        String dataInputName = dataInputAttributes.getNamedItem("from").getNodeValue();
        NamedNodeMap dataOutputAttributes = dataOutputList.item(0).getAttributes();
        String dataOutputName = dataOutputAttributes.getNamedItem("name").getNodeValue();
        NamedNodeMap notificationOutputAttributes = notificationOutputList.item(0).getAttributes();
        String notificationOutputName = notificationOutputAttributes.getNamedItem("name").getNodeValue();
        Node messageNode = messageList.item(0);
        this.mMessage = messageNode.getFirstChild().getNodeValue();
        this.mInternalInputs = new String[]{dataInputName};
        this.mInternalOutputs = new String[]{dataOutputName, notificationOutputName};
        this.mNotifyType = notifyType.equalsIgnoreCase("complete") ? 2 : (notifyType.equalsIgnoreCase("commenced") ? 1 : 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Notification activity: data input = " + dataInputName + ", data output = " + dataOutputName + ", notification output = " + notificationOutputName + ", message = " + this.mMessage);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mDataInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mDataOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.mNotificationOutput = this.mContext.getOutput(this.mInternalOutputs[1]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processFirst() {
        if (this.mNotifyType == 1) {
            this.mNotificationOutput.put((Object)this.mMessage);
        }
    }

    public void processBlock() {
        if (this.mDataInput.hasNext()) {
            Object input = this.mDataInput.next();
            this.mDataOutput.put(input);
        } else {
            if (this.mNotifyType == 2) {
                this.mNotificationOutput.put((Object)this.mMessage);
            }
            this.mDataOutput.close();
            this.mNotificationOutput.close();
            this.setCompleted();
        }
    }
}

