/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.misc;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.misc.DataStoreXMLTextException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.UnsupportedBlockException;

public class DataStoreActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private boolean mValuesHardcoded;
    private BlockReader mInput;
    private BlockWriter mOutput;
    private Iterator mItems;

    public DataStoreActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        this.mInternalOutputs = new String[]{((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "itemCursor").item(0)).getAttribute("name")};
        if (element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "input").getLength() == 0) {
            this.constructHardcoded(element);
        } else {
            this.constructInputFed(element);
        }
    }

    private void constructInputFed(Element element) {
        this.mValuesHardcoded = false;
        this.mInternalInputs = new String[]{((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "input").item(0)).getAttribute("from")};
    }

    private void constructHardcoded(Element element) throws ActivitySpecificationException {
        this.mValuesHardcoded = true;
        NodeList itemElements = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "item");
        ArrayList<Object> items = new ArrayList<Object>(itemElements.getLength());
        for (int i = 0; i < itemElements.getLength(); ++i) {
            items.add(this.getItemObject((Element)itemElements.item(i)));
        }
        this.mItems = items.iterator();
    }

    private Object getItemObject(Element itemElement) throws ActivitySpecificationException {
        Object item = null;
        NodeList valueNodes = itemElement.getChildNodes();
        StringBuffer sb = new StringBuffer();
        DocumentFragment docFragment = itemElement.getOwnerDocument().createDocumentFragment();
        boolean xmlContent = false;
        boolean textContent = false;
        for (int j = 0; j < valueNodes.getLength(); ++j) {
            Node node = valueNodes.item(j);
            if (node.getNodeType() == 3) {
                sb.append(node.getNodeValue());
                textContent = true;
                continue;
            }
            if (node.getNodeType() == 4) {
                sb.append(node.getNodeValue());
                textContent = true;
                continue;
            }
            if (node.getNodeType() == 1) {
                docFragment.appendChild(node);
                xmlContent = true;
                continue;
            }
            throw new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(node.getClass().getName()));
        }
        if (textContent && xmlContent) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)((Object)new DataStoreXMLTextException()));
        }
        if (textContent) {
            item = sb.toString();
        } else if (xmlContent) {
            item = docFragment;
        }
        return item;
    }

    protected void processBlock() {
        if (this.mItems == null && !this.mValuesHardcoded) {
            ArrayList<Object> items = new ArrayList<Object>();
            while (this.mInput.hasNext()) {
                items.add(this.mInput.next());
            }
            this.mItems = items.iterator();
        }
        if (this.mItems.hasNext()) {
            this.mOutput.put(this.mItems.next());
        } else {
            this.setCompleted();
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            if (!this.mValuesHardcoded) {
                this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            }
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }
}

