/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.indexedfiles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import uk.org.ogsadai.activity.indexedfiles.FlatFileIndexWriter;
import uk.org.ogsadai.common.msgs.DAILogger;

public class SwissProtIndexWriter
extends FlatFileIndexWriter {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)SwissProtIndexWriter.class);
    private HashMap mFields = new HashMap();

    public SwissProtIndexWriter(IndexWriter indexwriter) {
        super(indexwriter);
    }

    public void indexFiles(File[] files, String[] dirs) throws FileNotFoundException, IOException {
        if (this.mFields.size() == 0) {
            return;
        }
        int numFiles = files.length;
        for (int i = 0; i < numFiles; ++i) {
            this.indexFile(files[i], dirs[i]);
        }
    }

    public String[] getFields() {
        String[] fields = new String[this.mFields.size()];
        return this.mFields.keySet().toArray(fields);
    }

    public void setFields(String[] fields) {
        int numFields = fields.length;
        for (int i = 0; i < numFields; ++i) {
            this.mFields.put(fields[i], new StringBuffer());
        }
    }

    private void indexFile(File file, String relativePath) throws FileNotFoundException, IOException {
        RandomAccessFile data = new RandomAccessFile(file, "r");
        String line = null;
        Document doc = new Document();
        long numDocs = 0L;
        long docStart = 0L;
        if (!relativePath.endsWith("/")) {
            relativePath = relativePath + "/";
        }
        while ((line = data.readLine()) != null) {
            String lineType;
            StringBuffer value;
            if (line.startsWith("//")) {
                doc.add(Field.UnIndexed((String)"__datafile", (String)(relativePath + file.getName())));
                doc.add(Field.UnIndexed((String)"__offset", (String)String.valueOf(docStart)));
                doc.add(Field.UnIndexed((String)"__length", (String)String.valueOf(data.getFilePointer() - docStart)));
                Iterator iterator = this.mFields.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    doc.add(Field.Text((String)key, (String)this.mFields.get(key).toString()));
                    this.mFields.put(key, new StringBuffer());
                }
                this.mIndexWriter.addDocument(doc);
                doc = new Document();
                docStart = data.getFilePointer();
                if (++numDocs % 1000L != 0L || !LOG.isDebugEnabled()) continue;
                LOG.debug("Added " + numDocs + " documents.");
                continue;
            }
            if (line.length() < 2 || (value = (StringBuffer)this.mFields.get(lineType = line.substring(0, 2))) == null) continue;
            value.append(line.substring(5));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("SwissProt index writer: Indexed " + numDocs + " documents.");
        }
        data.close();
    }
}

