/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.indexedfiles;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.files.AbstractFileActivity;
import uk.org.ogsadai.activity.indexedfiles.IllegalIndexedFileQueryException;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIIOException;

public class SearchIndexedFileActivity
extends AbstractFileActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)SearchIndexedFileActivity.class);
    private static final String ANALYZER_CLASS_NAME = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private String mQueryExpression;
    private Query mQuery;
    private File mIndex;
    private String mIndexName;
    private IndexSearcher mSearcher;
    private Hits mHits;
    private int mCursor;
    private BlockWriter mDocumentLocationsOutput;
    private BlockWriter mSearchResultsOutput;

    public SearchIndexedFileActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        Node node = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "query").item(0);
        if (null == node) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No query expression found.");
            }
            this.mQuery = null;
        } else {
            this.mQueryExpression = node.getFirstChild().getNodeValue();
        }
        this.mIndexName = "index";
        NodeList indexList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "index");
        if (indexList.getLength() > 0) {
            node = indexList.item(0);
            if (node == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalid index directory.");
                }
            } else {
                this.mIndexName = node.getFirstChild().getNodeValue();
            }
        }
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        Element status = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "status").item(0);
        this.mInternalOutputs = new String[]{output.getAttribute("name"), status.getAttribute("name")};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialise: start");
        }
        try {
            this.mDocumentLocationsOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.mSearchResultsOutput = this.mContext.getOutput(this.mInternalOutputs[1]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        this.mHits = null;
        this.mCursor = 0;
        try {
            this.mIndex = new File(this.mTopDir, this.mIndexName);
            this.mFileAccessProvider.validateReadFile(this.mCredentials, this.mIndex);
            FileUtilities.directoryExists((File)this.mIndex);
        }
        catch (DAIDirectoryNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "index", (Throwable)new DAIDirectoryNotFoundException(new File(this.mIndexName), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        try {
            Class<?> analyzer = Class.forName(ANALYZER_CLASS_NAME);
            this.mQuery = QueryParser.parse((String)this.mQueryExpression, null, (Analyzer)((Analyzer)analyzer.newInstance()));
        }
        catch (ClassNotFoundException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassNotFoundException(ANALYZER_CLASS_NAME));
        }
        catch (InstantiationException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassCreateException(ANALYZER_CLASS_NAME, (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassCreateException(ANALYZER_CLASS_NAME, (Throwable)e));
        }
        catch (ParseException e) {
            throw new ActivitySpecificationException(this.getName(), "query", (Throwable)((Object)new IllegalIndexedFileQueryException(this.mQueryExpression, e)));
        }
    }

    protected void processFirst() {
        try {
            this.mSearcher = new IndexSearcher(this.mIndex.getCanonicalPath());
            this.mHits = this.mSearcher.search(this.mQuery);
            if (this.mHits == null || this.mHits.length() == 0) {
                this.mSearchResultsOutput.put((Object)"<searchResult resultCount=\"0\" />");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No matching documents.");
                }
                this.mSearcher.close();
                this.setCompleted();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + this.mHits.length() + " matching document(s).");
                }
                this.mSearchResultsOutput.put((Object)("<searchResult resultCount=\"" + this.mHits.length() + "\">\n"));
            }
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    protected void processBlock() {
        if (this.mHits == null || this.mCursor >= this.mHits.length()) {
            try {
                this.mSearcher.close();
                this.mSearchResultsOutput.put((Object)"</searchResult>\n");
            }
            catch (IOException e) {
                LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
            }
            this.setCompleted();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing hit " + this.mCursor);
        }
        try {
            Document doc = this.mHits.doc(this.mCursor);
            Field field = doc.getField("__datafile");
            String dataFilename = null;
            if (field != null) {
                dataFilename = field.stringValue();
            }
            field = doc.getField("__offset");
            String offset = null;
            if (field != null) {
                offset = field.stringValue();
            }
            field = doc.getField("__length");
            String length = null;
            if (field != null) {
                length = field.stringValue();
            }
            StringBuffer outputBuf = new StringBuffer();
            if (dataFilename != null) {
                outputBuf.append("<readFile name=\"" + this.mHits.id(this.mCursor) + "\">\n");
                outputBuf.append("  <file>" + dataFilename + "</file>\n");
                outputBuf.append("  <bytes ");
                if (offset != null) {
                    outputBuf.append("offset=\"" + offset + "\" ");
                }
                if (length != null) {
                    outputBuf.append("length=\"" + length + "\"");
                }
                outputBuf.append("/>\n");
                outputBuf.append("</readFile>\n");
                this.mDocumentLocationsOutput.put((Object)outputBuf.toString());
            }
            StringBuffer searchBuf = new StringBuffer();
            searchBuf.append("<document id=\"");
            searchBuf.append(this.mHits.id(this.mCursor));
            searchBuf.append("\">\n");
            Enumeration enumeration = doc.fields();
            while (enumeration.hasMoreElements()) {
                field = (Field)enumeration.nextElement();
                if (!field.isStored() || field.name().startsWith("__")) continue;
                searchBuf.append("<field name=\"" + field.name() + "\">");
                searchBuf.append(field.stringValue());
                searchBuf.append("</field>\n");
            }
            searchBuf.append("</document>\n");
            this.mSearchResultsOutput.put((Object)searchBuf.toString());
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
        ++this.mCursor;
    }

    protected void cleanUp() {
        try {
            if (this.mSearcher != null) {
                this.mSearcher.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }
}

