/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.indexedfiles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import uk.org.ogsadai.activity.indexedfiles.FlatFileIndexWriter;
import uk.org.ogsadai.common.msgs.DAILogger;

public class OMIMIndexWriter
extends FlatFileIndexWriter {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)OMIMIndexWriter.class);
    private HashMap mFields = new HashMap();

    public OMIMIndexWriter(IndexWriter indexwriter) {
        super(indexwriter);
    }

    public void indexFiles(File[] files, String[] dirs) throws FileNotFoundException, IOException {
        if (this.mFields.size() == 0) {
            return;
        }
        int numFiles = files.length;
        for (int i = 0; i < numFiles; ++i) {
            this.indexFile(files[i], dirs[i]);
        }
    }

    public String[] getFields() {
        String[] fields = new String[this.mFields.size()];
        return this.mFields.keySet().toArray(fields);
    }

    public void setFields(String[] fields) {
        int numFields = fields.length;
        for (int i = 0; i < numFields; ++i) {
            this.mFields.put(fields[i], new StringBuffer());
        }
    }

    private void indexFile(File file, String relativePath) throws FileNotFoundException, IOException {
        if (!relativePath.endsWith("/")) {
            relativePath = relativePath + "/";
        }
        RandomAccessFile data = new RandomAccessFile(file, "r");
        String line = null;
        Document doc = new Document();
        String fieldType = null;
        StringBuffer fieldValue = null;
        long numDocs = 0L;
        long lineStart = 0L;
        long docStart = 0L;
        while ((line = data.readLine()) != null) {
            if (line.startsWith("*RECORD*") || line.startsWith("*THEEND*")) {
                if (numDocs != 0L) {
                    doc.add(Field.UnIndexed((String)"__datafile", (String)(relativePath + file.getName())));
                    doc.add(Field.UnIndexed((String)"__offset", (String)String.valueOf(docStart)));
                    doc.add(Field.UnIndexed((String)"__length", (String)String.valueOf(lineStart - docStart)));
                    Iterator iterator = this.mFields.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        doc.add(Field.Text((String)key, (String)this.mFields.get(key).toString()));
                        this.mFields.put(key, new StringBuffer());
                    }
                    this.mIndexWriter.addDocument(doc);
                    doc = new Document();
                    if (numDocs % 1000L == 0L && LOG.isDebugEnabled()) {
                        LOG.debug("Added " + numDocs + " documents.");
                    }
                }
                ++numDocs;
                docStart = lineStart;
            } else {
                if (line.length() < 1) continue;
                if (line.startsWith("*FIELD*")) {
                    fieldType = line.substring(8, 10);
                    fieldValue = (StringBuffer)this.mFields.get(fieldType);
                    if (fieldValue == null) {
                        fieldType = null;
                    }
                } else if (fieldValue != null) {
                    fieldValue.append(line + "\n");
                }
            }
            lineStart = data.getFilePointer();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OMIM index writer: Indexed " + numDocs + " documents.");
        }
        data.close();
    }
}

