/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.indexedfiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.files.AbstractFileActivity;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public class FileReadingActivity
extends AbstractFileActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)FileReadingActivity.class);
    private static final int BLOCK_SIZE = 1024;
    private String mFilename = null;
    private File mFile = null;
    private RandomAccessFile mBinaryFile;
    private BufferedReader mTextFile;
    private boolean mBase64encode;
    private boolean mIsBinaryFile;
    private long mOffset = 0L;
    private long mLength = -1L;
    private BlockWriter mOutput;
    private BlockReader mInput = null;

    public FileReadingActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        Node node = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "file").item(0);
        if (node != null) {
            this.mFilename = node.getFirstChild().getNodeValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Filename is " + this.mFilename);
            }
        } else {
            Element inp = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromLocal").item(0);
            this.mInternalInputs = new String[]{inp.getAttribute("from")};
        }
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        this.mInternalOutputs = new String[]{output.getAttribute("name")};
        String type = output.getAttribute("base64encode");
        if (type != null) {
            if (type.equalsIgnoreCase("true") || type.equals("1")) {
                this.mBase64encode = true;
            } else if (type.equalsIgnoreCase("false") || type.equals("0")) {
                this.mBase64encode = false;
            } else {
                throw new ActivitySpecificationException(this.getName(), "type");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Base64 encoding is " + this.mBase64encode);
        }
        this.parseOffsetAndLength("http://ogsadai.org.uk/namespaces/2005/10/types", element);
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialise: start");
        }
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            if (this.mFilename == null) {
                this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            } else {
                this.mFile = new File(this.mTopDir, this.mFilename);
                this.mFileAccessProvider.validateReadFile(this.mCredentials, this.mFile);
                FileUtilities.fileExists((File)this.mFile);
                FileUtilities.isFileReadable((File)this.mFile);
            }
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "file", (Throwable)new DAIFileNotFoundException(new File(this.mFilename), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    protected void processFirst() {
        try {
            if (this.mInput != null && !this.hasNextFile()) {
                this.setCompleted();
                return;
            }
            if (!this.openFile(this.mFilename)) {
                this.setCompleted();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    protected void processBlock() {
        block16: {
            if (this.mIsBinaryFile) {
                try {
                    int numBytes = this.readFromBinaryFile();
                    if (numBytes != -1 && this.mLength > 0L) break block16;
                    this.mBinaryFile.close();
                    if (this.hasNextFile()) {
                        this.openFile(this.mFilename);
                        break block16;
                    }
                    this.setCompleted();
                }
                catch (IOException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIFileReadIOException(this.mFile, e)));
                }
                catch (DAIFileReadIOException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                }
                catch (ActivitySpecificationException e) {
                    this.setError(e);
                }
                catch (ActivityExecutionException e) {
                    this.setError(e);
                }
            } else {
                try {
                    boolean readLine = this.readFromTextFile();
                    if (!readLine || this.mLength <= 0L) {
                        this.mTextFile.close();
                        if (this.hasNextFile()) {
                            this.openFile(this.mFilename);
                        } else {
                            this.setCompleted();
                        }
                    }
                }
                catch (IOException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIFileReadIOException(this.mFile, e)));
                }
                catch (DAIFileReadIOException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                }
                catch (ActivitySpecificationException e) {
                    this.setError(e);
                }
                catch (ActivityExecutionException e) {
                    this.setError(e);
                }
            }
        }
    }

    protected void cleanUp() {
        try {
            if (this.mBinaryFile != null) {
                this.mBinaryFile.close();
            }
            if (this.mTextFile != null) {
                this.mTextFile.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    private boolean readFromTextFile() throws DAIFileReadIOException {
        String line = null;
        if (this.mLength > 0L) {
            try {
                line = this.mTextFile.readLine();
            }
            catch (IOException e) {
                throw new DAIFileReadIOException(this.mFile, e);
            }
            if (line == null) {
                return false;
            }
            if (this.mBase64encode) {
                this.mOutput.put((Object)(new String(new Base64().encode(line.getBytes())) + "\n"));
            } else {
                this.mOutput.put((Object)new String(line + "\n"));
            }
            --this.mLength;
        }
        return true;
    }

    private int readFromBinaryFile() throws DAIFileReadIOException {
        int length = this.mLength < 1024L ? (int)this.mLength : 1024;
        byte[] buf = new byte[length];
        int numBytes = 0;
        try {
            numBytes = this.mBinaryFile.read(buf, 0, length);
        }
        catch (IOException e) {
            throw new DAIFileReadIOException(this.mFile, e);
        }
        if (numBytes > 0) {
            this.mLength -= (long)numBytes;
            if (this.mBase64encode) {
                this.mOutput.put((Object)new String(new Base64().encode(buf, 0, numBytes)));
            } else {
                if (numBytes < 1024) {
                    byte[] block = new byte[numBytes];
                    System.arraycopy(buf, 0, block, 0, numBytes);
                } else {
                    byte[] block = buf;
                }
                this.mOutput.put((Object)buf);
            }
        }
        return numBytes;
    }

    private boolean hasNextFile() throws ActivitySpecificationException, ActivityExecutionException {
        if (this.mInput == null) {
            return false;
        }
        if (this.mInput.hasNext()) {
            String xml = (String)this.mInput.next();
            Element element = null;
            try {
                element = XMLUtilities.xmlStringToDOM((String)xml, (boolean)false).getDocumentElement();
            }
            catch (XMLDocumentException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)e);
            }
            catch (XMLParseException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (Exception e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            if (!element.getNodeName().equals("readFile")) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new XMLMissingElementException("readFile"));
            }
            Node node = element.getElementsByTagName("file").item(0);
            if (node == null) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new XMLMissingElementException("file"));
            }
            this.mFilename = node.getFirstChild().getNodeValue();
            this.parseOffsetAndLength("", element);
            return true;
        }
        return false;
    }

    private void parseOffsetAndLength(String namespace, Element element) throws ActivitySpecificationException {
        Element linesElt;
        this.mLength = -1L;
        this.mOffset = 0L;
        Element elt = null;
        Element binaryElt = (Element)element.getElementsByTagNameNS(namespace, "bytes").item(0);
        if (binaryElt != null) {
            this.mIsBinaryFile = true;
            elt = binaryElt;
        }
        if ((linesElt = (Element)element.getElementsByTagNameNS(namespace, "lines").item(0)) != null) {
            this.mIsBinaryFile = false;
            elt = linesElt;
        }
        if (elt != null) {
            String s = elt.getAttribute("offset");
            if (s != null || !s.equals("")) {
                try {
                    this.mOffset = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)new DAINumberFormatException(s));
                }
            }
            if ((s = elt.getAttribute("length")) != null || !s.equals("")) {
                try {
                    this.mLength = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    throw new ActivitySpecificationException(this.getName(), "length", (Throwable)new DAINumberFormatException(s));
                }
            }
            if (this.mOffset < 0L) {
                throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)new DAIOutOfBoundsException(this.mOffset, 1L));
            }
            if (this.mLength < -1L) {
                throw new ActivitySpecificationException(this.getName(), "length", (Throwable)new DAIOutOfBoundsException(this.mLength, -1L));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Offset: " + this.mOffset + ", length: " + this.mLength);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openFile(String filename) throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mFile = new File(this.mTopDir, this.mFilename);
            this.mFileAccessProvider.validateReadFile(this.mCredentials, this.mFile);
            FileUtilities.fileExists((File)this.mFile);
            FileUtilities.isFileReadable((File)this.mFile);
            if (this.mIsBinaryFile) {
                this.mBinaryFile = new RandomAccessFile(this.mFile, "r");
                if (this.mLength == -1L) {
                    this.mLength = this.mBinaryFile.length();
                }
                if (this.mBinaryFile.length() > this.mOffset) {
                    this.mBinaryFile.seek(this.mOffset);
                    return true;
                }
                this.mBinaryFile.close();
                return false;
            }
            this.mTextFile = new BufferedReader(new FileReader(this.mFile));
            if (this.mLength == -1L) {
                this.mLength = Long.MAX_VALUE;
            }
            String line = null;
            if (this.mOffset <= 0L) return true;
            while (this.mOffset > 0L && (line = this.mTextFile.readLine()) != null) {
                --this.mOffset;
            }
            if (line != null) return true;
            this.mTextFile.close();
            return false;
        }
        catch (FileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "file", (Throwable)new DAIFileNotFoundException(new File(this.mFilename), true));
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "file", (Throwable)new DAIFileNotFoundException(new File(this.mFilename), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIFileReadIOException(this.mFile, e));
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }
}

