/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.indexedfiles;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityConfiguration;
import uk.org.ogsadai.activity.ActivityConfigurationException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;

public class AddAndIndexFileActivityConfiguration
implements ActivityConfiguration {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)AddAndIndexFileActivityConfiguration.class);
    private Map mIndexers = null;
    private Map mAnalyzers = null;
    private String mName;

    public AddAndIndexFileActivityConfiguration(String name) {
        this.mName = name;
    }

    public void initialise(Document document) throws ActivityConfigurationException {
        NodeList indexerList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialise: enter");
        }
        if ((indexerList = document.getElementsByTagNameNS("", "fileIndexer")) == null || indexerList.getLength() == 0) {
            throw new ActivityConfigurationException(this.mName, (Throwable)new XMLMissingElementException("fileIndexer"));
        }
        int numIndexers = indexerList.getLength();
        this.mIndexers = new HashMap(numIndexers);
        this.mAnalyzers = new HashMap(numIndexers);
        for (int i = 0; i < numIndexers; ++i) {
            Element indexerElement = (Element)indexerList.item(i);
            String filetype = this.getAttribute("filetype", indexerElement);
            String impl = this.getAttribute("implementation", indexerElement);
            this.mIndexers.put(filetype.toUpperCase(), impl);
            String analyzer = this.getAttribute("analyzer", indexerElement);
            this.mAnalyzers.put(filetype.toUpperCase(), analyzer);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Found indexer for filetype: " + filetype);
            LOG.debug(" - implementation class: " + impl);
            LOG.debug(" - analyzer class: " + analyzer);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialise: exit");
        }
    }

    public String getAnalyzer(String filetype) {
        if (this.mAnalyzers == null) {
            return null;
        }
        return (String)this.mAnalyzers.get(filetype.toUpperCase());
    }

    public String getIndexHelperClass(String filetype) {
        if (this.mIndexers == null) {
            return null;
        }
        return (String)this.mIndexers.get(filetype.toUpperCase());
    }

    private String getAttribute(String name, Element element) throws ActivityConfigurationException {
        String value = element.getAttribute(name);
        if (value == null || value.trim().equals("")) {
            throw new ActivityConfigurationException(this.mName, (Throwable)new XMLMissingAttributeException(element.getNodeName(), name));
        }
        return value;
    }
}

