/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.indexedfiles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityConfiguration;
import uk.org.ogsadai.activity.ActivityConfigurationCreator;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.files.AbstractFileActivity;
import uk.org.ogsadai.activity.indexedfiles.AddAndIndexFileActivityConfiguration;
import uk.org.ogsadai.activity.indexedfiles.FlatFileIndexWriter;
import uk.org.ogsadai.activity.indexedfiles.NoAnalyzerException;
import uk.org.ogsadai.activity.indexedfiles.NoIndexerException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.DAIFileFoundException;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileWriteIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingMethodException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAIMethodInvocationException;

public class AddAndIndexFileActivity
extends AbstractFileActivity
implements ActivityConfigurationCreator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)AddAndIndexFileActivity.class);
    private String mFilename;
    private File mFile;
    private FileOutputStream mFileOutput;
    private String mDirname;
    private File mDirectory;
    private String mFiletype;
    private String mIndexName;
    private File mIndex;
    private String[] mFields;
    private IndexWriter mIndexWriter;
    private FlatFileIndexWriter mIndexHelper;
    private BlockReader mInput;

    public AddAndIndexFileActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        NodeList fields = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "field");
        if (null == fields || fields.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), "field");
        }
        int numFields = fields.getLength();
        this.mFields = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.mFields[i] = fields.item(i).getFirstChild().getNodeValue();
        }
        this.mFilename = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "filename").item(0).getFirstChild().getNodeValue();
        this.mDirname = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "directory").item(0).getFirstChild().getNodeValue();
        this.mFiletype = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "filetype").item(0).getFirstChild().getNodeValue();
        this.mIndexName = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "index").item(0).getFirstChild().getNodeValue();
        Element inp = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromLocal").item(0);
        if (inp == null) {
            throw new ActivitySpecificationException(this.getName(), "fromLocal");
        }
        this.mInternalInputs = new String[]{inp.getAttribute("from")};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialise: start");
        }
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        try {
            this.mDirectory = new File(this.mTopDir, this.mDirname);
            this.mFile = new File(this.mDirectory, this.mFilename);
            this.mIndex = new File(this.mTopDir, this.mIndexName);
            this.mFileAccessProvider.validateWriteFile(this.mCredentials, this.mFile);
            this.mFileAccessProvider.validateWriteFile(this.mCredentials, this.mIndex);
            FileUtilities.fileDoesntExist((File)this.mFile);
            FileUtilities.directoryExists((File)this.mIndex);
        }
        catch (DAIDirectoryNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "directory", (Throwable)new DAIDirectoryNotFoundException(new File(this.mDirname), true));
        }
        catch (DAIFileFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "filename", (Throwable)new DAIFileFoundException(new File(this.mFilename), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        String analyzerName = null;
        try {
            analyzerName = ((AddAndIndexFileActivityConfiguration)this.getActivityConfiguration()).getAnalyzer(this.mFiletype);
            if (analyzerName == null || analyzerName.equals("")) {
                throw new ActivitySpecificationException(this.getName(), "fileType", (Throwable)((Object)new NoAnalyzerException(this.mFiletype)));
            }
            Class<?> analyzerClass = Class.forName(analyzerName);
            Analyzer analyzer = (Analyzer)analyzerClass.newInstance();
            this.mIndexWriter = new IndexWriter(this.mIndex, analyzer, true);
        }
        catch (ClassNotFoundException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassNotFoundException(analyzerName));
        }
        catch (InstantiationException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassCreateException(analyzerName, (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassCreateException(analyzerName, (Throwable)e));
        }
        catch (IOException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e));
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        String indexHelperClass = null;
        Class[] parameters = new Class[]{this.mIndexWriter.getClass()};
        try {
            indexHelperClass = ((AddAndIndexFileActivityConfiguration)this.getActivityConfiguration()).getIndexHelperClass(this.mFiletype);
            if (indexHelperClass == null) {
                throw new ActivitySpecificationException(this.getName(), "fileType", (Throwable)((Object)new NoIndexerException(this.mFiletype)));
            }
            Class<?> indexClass = Class.forName(indexHelperClass);
            Constructor<?> constructor = indexClass.getConstructor(this.mIndexWriter.getClass());
            this.mIndexHelper = (FlatFileIndexWriter)constructor.newInstance(this.mIndexWriter);
        }
        catch (ClassNotFoundException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassNotFoundException(indexHelperClass));
        }
        catch (InstantiationException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassCreateException(indexHelperClass, (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassCreateException(indexHelperClass, (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIClassMissingMethodException(indexHelperClass, indexHelperClass, parameters));
        }
        catch (InvocationTargetException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIMethodInvocationException(indexHelperClass, indexHelperClass, parameters));
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    protected void processFirst() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processFirst: start");
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Opening output file");
            }
            this.mFileOutput = new FileOutputStream(this.mFile);
        }
        catch (FileNotFoundException e) {
            this.setError(new ActivitySpecificationException(this.getName(), "filename", (Throwable)new DAIFileNotFoundException(this.mFile)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processFirst: end");
        }
    }

    protected void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        if (this.mInput.hasNext()) {
            Object obj = this.mInput.next();
            if (obj instanceof byte[]) {
                byte[] block = (byte[])obj;
                try {
                    this.mFileOutput.write(block);
                }
                catch (IOException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIFileWriteIOException(this.mFile, e)));
                }
            } else {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(obj.getClass().getName())));
            }
        } else {
            try {
                this.mFileOutput.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished importing file into file system.");
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIFileWriteIOException(this.mFile, e)));
            }
            this.indexFile();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }

    protected void cleanUp() {
        try {
            if (this.mFileOutput != null) {
                this.mFileOutput.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIFileWriteIOException(this.mFile, e)));
        }
        try {
            if (this.mIndexWriter != null) {
                this.mIndexWriter.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
        catch (Throwable e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), e));
        }
    }

    private void indexFile() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting to index file");
        }
        try {
            this.mIndexHelper.setFields(this.mFields);
            this.mIndexHelper.indexFiles(new File[]{this.mFile}, new String[]{this.mDirname});
            this.mIndexWriter.optimize();
            this.mIndexWriter.close();
            this.setCompleted();
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished indexing file");
        }
    }

    public ActivityConfiguration createActivityConfiguration() {
        AddAndIndexFileActivityConfiguration config = new AddAndIndexFileActivityConfiguration(super.getName());
        return config;
    }
}

