/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files.regexp;

import org.apache.oro.text.awk.AwkMatcher;
import org.apache.oro.text.awk.AwkPattern;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;
import uk.org.ogsadai.activity.files.regexp.AbstractMatcher;
import uk.org.ogsadai.activity.files.regexp.UnsupportedRegexpPatternFormatException;

public class OroMatcher
extends AbstractMatcher {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private Pattern mPattern;
    private PatternMatcher mMatcher;
    private PatternMatcherInput mInput;

    public OroMatcher(Pattern pattern) throws UnsupportedRegexpPatternFormatException {
        if (pattern instanceof Perl5Pattern) {
            this.mMatcher = new Perl5Matcher();
        } else if (pattern instanceof AwkPattern) {
            this.mMatcher = new AwkMatcher();
        } else {
            throw new UnsupportedRegexpPatternFormatException(pattern.getClass().getName());
        }
        this.mPattern = pattern;
        this.mInput = new PatternMatcherInput(new char[0]);
    }

    public void setInput(String input) {
        this.mInput.setInput(input, this.mSearchOffset, input.length() - this.mSearchOffset);
    }

    public boolean findNextMatch() throws IllegalStateException {
        if (this.mInput.getInput() instanceof char[] && ((char[])this.mInput.getInput()).length == 0) {
            throw new IllegalStateException("No input registered! Please use the setInput method");
        }
        return this.mMatcher.contains(this.mInput, this.mPattern);
    }

    public int startOffset() {
        MatchResult result = this.mMatcher.getMatch();
        if (result == null) {
            throw new IllegalStateException("No match available");
        }
        return result.beginOffset(0);
    }

    public int endOffset() {
        MatchResult result = this.mMatcher.getMatch();
        if (result == null) {
            throw new IllegalStateException("No match available");
        }
        return result.endOffset(0);
    }

    public int groupCount() {
        MatchResult result = this.mMatcher.getMatch();
        if (result == null) {
            throw new IllegalStateException("No match available");
        }
        return result.groups() - 1;
    }

    public String group(int index) {
        MatchResult result = this.mMatcher.getMatch();
        if (result == null) {
            throw new IllegalStateException("No match available");
        }
        return result.group(index);
    }
}

