/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files;

import uk.org.ogsadai.activity.files.MalformedReplacementStringException;

public class SubstitutionStringParser {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private String mString;
    private String[] mGroups;
    private int mIndex;
    private char mToken;

    public SubstitutionStringParser(String[] groups, String string) {
        this.mGroups = groups;
        this.mString = string;
        this.mIndex = 0;
        this.mToken = string.charAt(0);
    }

    public void lex() {
        ++this.mIndex;
        this.mToken = this.mIndex < this.mString.length() ? this.mString.charAt(this.mIndex) : (char)'\u0000';
    }

    public String readString() throws MalformedReplacementStringException {
        StringBuffer buf = new StringBuffer();
        while (this.mIndex < this.mString.length()) {
            buf.append(this.readChar());
        }
        return buf.toString();
    }

    private String readChar() throws MalformedReplacementStringException {
        switch (this.mToken) {
            case '\\': {
                this.lex();
                String output = this.outputToken(this.mToken);
                this.lex();
                return output;
            }
            case '$': {
                return this.readVar();
            }
        }
        String output2 = this.outputToken(this.mToken);
        this.lex();
        return output2;
    }

    private String readVar() throws MalformedReplacementStringException {
        if (this.mToken != '$') {
            throw new MalformedReplacementStringException("$");
        }
        this.lex();
        switch (this.mToken) {
            case '{': {
                this.lex();
                int var = this.readInt();
                if (this.mToken != '}') {
                    throw new MalformedReplacementStringException("}");
                }
                this.lex();
                return this.variable(var);
            }
        }
        int var2 = this.readInt();
        return this.variable(var2);
    }

    private int readInt() throws MalformedReplacementStringException {
        int val = 0;
        if (!SubstitutionStringParser.isNumber(this.mToken)) {
            throw new MalformedReplacementStringException("0|1|2|3|4|5|6|7|8|9");
        }
        while (SubstitutionStringParser.isNumber(this.mToken)) {
            int num = Integer.parseInt(Character.toString(this.mToken));
            val *= 10;
            val += num;
            this.lex();
        }
        return val;
    }

    private static boolean isNumber(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    private String variable(int var) {
        String value = this.mGroups[var];
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String outputToken(char token) {
        return Character.toString(token);
    }
}

