/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files;

import uk.org.ogsadai.activity.files.Lagrange;
import uk.org.ogsadai.activity.files.NonIncreasingSequenceException;

public class Sequence {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private Lagrange mLagrange;

    public Sequence(int[] items) throws NonIncreasingSequenceException {
        if (!this.increasing(items)) {
            throw new NonIncreasingSequenceException(items);
        }
        this.mLagrange = new Lagrange(items);
    }

    public String toString() {
        return this.mLagrange.toString();
    }

    private boolean increasing(int[] items) {
        for (int i = 1; i < items.length; ++i) {
            if (items[i] >= items[i - 1]) continue;
            return false;
        }
        return true;
    }

    public boolean isMember(int val) throws NonIncreasingSequenceException {
        double x;
        int i = 0;
        double prev = x = Double.NEGATIVE_INFINITY;
        int identicalCount = 0;
        while (x < (double)val) {
            if ((x = this.mLagrange.p(++i)) == prev) {
                ++identicalCount;
            }
            if (identicalCount == 1000) {
                throw new NonIncreasingSequenceException(this.mLagrange.toString());
            }
            prev = x;
        }
        return Sequence.toInt(x) == val;
    }

    private static int toInt(double number) {
        return (int)Math.round(number);
    }

    static String intArrayToString(int[] items) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < items.length; ++i) {
            buf.append(items[i] + ",");
        }
        buf.append("...]");
        return buf.toString();
    }
}

