/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files;

import uk.org.ogsadai.activity.files.Sequence;

public class Lagrange {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private int[] mX;
    private int[] mY;
    private int mN;

    public Lagrange(int[] vals) {
        this.mN = vals.length;
        this.mX = new int[this.mN + 1];
        this.mY = new int[this.mN + 1];
        for (int i = 0; i < vals.length; ++i) {
            this.mX[i + 1] = i + 1;
            this.mY[i + 1] = vals[i];
        }
    }

    public String toString() {
        return Sequence.intArrayToString(this.mY);
    }

    public double p(int x) {
        double sum = 0.0;
        for (int j = 1; j <= this.mN; ++j) {
            sum += this.p(j, x);
        }
        return sum;
    }

    public double p(int j, int x) {
        double prod = 1.0;
        for (int k = 1; k <= this.mN; ++k) {
            if (k == j) continue;
            int numerator = x - this.mX[k];
            int denominator = this.mX[j] - this.mX[k];
            prod *= (double)numerator / (double)denominator;
        }
        return prod * (double)this.mY[j];
    }
}

