/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.files.AbstractFileActivity;
import uk.org.ogsadai.activity.files.FileMatchExpressionException;
import uk.org.ogsadai.activity.files.InfiniteSet;
import uk.org.ogsadai.activity.files.MalformedReplacementStringException;
import uk.org.ogsadai.activity.files.NonIncreasingSequenceException;
import uk.org.ogsadai.activity.files.Sequence;
import uk.org.ogsadai.activity.files.SubstitutionStringParser;
import uk.org.ogsadai.activity.files.regexp.AbstractMatcher;
import uk.org.ogsadai.activity.files.regexp.MalformedRegexpPatternException;
import uk.org.ogsadai.activity.files.regexp.OroMatcher;
import uk.org.ogsadai.activity.files.regexp.OroPerl5Pattern;
import uk.org.ogsadai.activity.files.regexp.UnsupportedRegexpPatternFormatException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public class FileWritingActivity
extends AbstractFileActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)FileWritingActivity.class);
    public static final String SEQ_SEPARATOR = ":";
    public static final int STEP_SIZE_UPPER_LIMIT = 10000;
    public static final int NONE = 0;
    public static final int DELETE = 1;
    public static final int REPLACE = 2;
    public static final int APPEND = 3;
    public static final int INSERT = 4;
    public static final int OFFSET_AND_LENGTH = 1;
    public static final int REGEXP = 2;
    public static final boolean PER_FILE = true;
    public static final boolean PER_LINE = false;
    private int mType;
    private String mFilename;
    private File mFile;
    private RandomAccessFile mRaFile;
    private long mFileLength;
    private String mOffset;
    private String mLength;
    private String mRegexp;
    private InfiniteSet mMatch;
    private boolean mMultiline;
    private boolean mOptimiseForTime;
    private int mAction = 0;
    private BlockReader mInput;
    private BlockWriter mOutput;
    private String mString;
    private boolean mAlreadyReturnedBlank = false;

    public FileWritingActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList appendNodes;
        NodeList insertNodes;
        NodeList replaceNodes;
        NodeList deleteNodes;
        NodeList locateNodes;
        Node fileNode = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "file").item(0);
        this.mFilename = fileNode.getFirstChild().getNodeValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filename is " + this.mFilename);
        }
        if ((locateNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "locate")).getLength() == 1) {
            Element node = (Element)locateNodes.item(0);
            this.parseLocate(node);
        }
        if ((deleteNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "delete")).getLength() == 1) {
            this.mAction = 1;
            this.extractOptimiseAttribute((Element)deleteNodes.item(0));
        }
        if ((replaceNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "replace")).getLength() == 1) {
            this.mAction = 2;
            this.extractFromOrTextAttribute((Element)replaceNodes.item(0));
            this.extractOptimiseAttribute((Element)replaceNodes.item(0));
        }
        if ((insertNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "insert")).getLength() == 1) {
            this.mAction = 4;
            this.extractFromOrTextAttribute((Element)insertNodes.item(0));
            this.extractOptimiseAttribute((Element)insertNodes.item(0));
        }
        if ((appendNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "append")).getLength() == 1) {
            this.mAction = 3;
            this.mOffset = "end";
            this.extractFromOrTextAttribute((Element)appendNodes.item(0));
            this.extractOptimiseAttribute((Element)appendNodes.item(0));
        }
        if (this.mAction == 0) {
            throw new ActivitySpecificationException(this.getName(), "delete|insert|replace|append");
        }
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        this.mInternalOutputs = new String[]{output.getAttribute("name")};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsed perform document yielded:");
            LOG.debug(" - Filename: " + this.mFilename);
            LOG.debug(" - Offset: " + this.mOffset);
            LOG.debug(" - Length: " + this.mLength);
            LOG.debug(" - Regexp: \"" + this.mRegexp + "\"");
            LOG.debug(" - Match: " + this.mMatch);
            LOG.debug(" - Multiline: " + this.mMultiline);
            LOG.debug(" - Optimise time: " + this.mOptimiseForTime);
            LOG.debug(" - Type: " + this.mAction);
            LOG.debug(" - Text: \"" + this.mString + "\"");
        }
    }

    private InfiniteSet parseMatch(String list) throws ActivitySpecificationException {
        InfiniteSet numbers = new InfiniteSet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing match items...");
        }
        try {
            StringTokenizer commaTokenizer = new StringTokenizer(list, ",");
            while (commaTokenizer.hasMoreTokens()) {
                StringTokenizer hyphenTokenizer;
                StringTokenizer colonTokenizer;
                String token = commaTokenizer.nextToken();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found match item \"" + token + "\".");
                }
                if ((colonTokenizer = new StringTokenizer(token, SEQ_SEPARATOR)).countTokens() > 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The match item \"" + token + "\" is a sequence.");
                    }
                    if (token.endsWith(":...")) {
                        ArrayList<String> tokens = new ArrayList<String>();
                        while (colonTokenizer.hasMoreTokens()) {
                            String seqToken = colonTokenizer.nextToken();
                            if (seqToken.equals("...")) continue;
                            tokens.add(seqToken);
                        }
                        int[] seq = new int[tokens.size()];
                        for (int i = 0; i < tokens.size(); ++i) {
                            seq[i] = this.parseInt((String)tokens.get(i));
                        }
                        Sequence sequence = new Sequence(seq);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding sequence " + sequence + ".");
                        }
                        numbers.add(sequence);
                        continue;
                    }
                    throw new FileMatchExpressionException(list);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The token \"" + token + "\" is not a sequence, so it must be a single number or a range.");
                }
                if ((hyphenTokenizer = new StringTokenizer(token, "-")).countTokens() == 1) {
                    int val = this.parseInt(hyphenTokenizer.nextToken());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("It is just a single number, with value " + val + ".");
                    }
                    numbers.add(val);
                    continue;
                }
                if (hyphenTokenizer.countTokens() == 2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("It is a range.");
                    }
                    if (token.endsWith("-")) {
                        int start = this.parseInt(hyphenTokenizer.nextToken());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("It's an infinite range, with start value " + start + ".");
                        }
                        int[] seq = new int[]{start, start + 1};
                        Sequence sequence = new Sequence(seq);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding sequence " + sequence + ".");
                        }
                        numbers.add(sequence);
                        continue;
                    }
                    int start = this.parseInt(hyphenTokenizer.nextToken());
                    int end = this.parseInt(hyphenTokenizer.nextToken());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("It's a finite range, with start value " + start + " and end value " + end + ".");
                        LOG.debug("Adding range " + start + " - " + end);
                    }
                    numbers.add(start, end);
                    continue;
                }
                throw new FileMatchExpressionException(list);
            }
        }
        catch (FileMatchExpressionException e) {
            throw new ActivitySpecificationException(this.getName(), "match", (Throwable)((Object)e));
        }
        catch (DAINumberFormatException e) {
            throw new ActivitySpecificationException(this.getName(), "match", (Throwable)e);
        }
        catch (NonIncreasingSequenceException e) {
            throw new ActivitySpecificationException(this.getName(), "match", (Throwable)((Object)e));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished parsing match items. Obtained: " + numbers.toString());
        }
        return numbers;
    }

    private int parseInt(String intString) throws DAINumberFormatException {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw new DAINumberFormatException(intString);
        }
    }

    private void parseLocate(Element node) throws ActivitySpecificationException {
        Element perLine;
        String perLineValue;
        if (node == null) {
            this.mType = 0;
            return;
        }
        NodeList offsetNodes = node.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "offset");
        NodeList lengthNodes = node.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "length");
        NodeList perLineNodes = node.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "perLine");
        NodeList regexpNodes = node.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "regexp");
        NodeList matchNodes = node.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "match");
        this.mType = regexpNodes.getLength() == 1 ? 2 : 1;
        if (this.mType == 1) {
            if (offsetNodes.getLength() == 1) {
                Element offset = (Element)offsetNodes.item(0);
                this.mOffset = offset.getFirstChild().getNodeValue();
            } else {
                this.mOffset = null;
            }
            if (lengthNodes.getLength() == 1) {
                Element length = (Element)lengthNodes.item(0);
                this.mLength = length.getFirstChild().getNodeValue();
            } else {
                this.mLength = null;
            }
        } else {
            if (regexpNodes.getLength() == 1) {
                Element regexp = (Element)regexpNodes.item(0);
                this.mRegexp = regexp.getFirstChild().getNodeValue();
            }
            if (matchNodes.getLength() == 1) {
                Element match = (Element)matchNodes.item(0);
                this.mMatch = this.parseMatch(match.getFirstChild().getNodeValue());
            } else {
                this.mMatch = this.parseMatch("1:2:...");
            }
        }
        this.mMultiline = perLineNodes.getLength() == 1 ? !(perLineValue = (perLine = (Element)perLineNodes.item(0)).getFirstChild().getNodeValue()).equalsIgnoreCase("true") && !perLineValue.equals("1") : true;
    }

    private void extractOptimiseAttribute(Element node) {
        String optimiseAttrib = node.getAttribute("optimiseSpeed");
        this.mOptimiseForTime = optimiseAttrib.equals("") || optimiseAttrib.equalsIgnoreCase("true") || optimiseAttrib.equals("1");
    }

    private void extractFromOrTextAttribute(Element node) throws ActivitySpecificationException {
        String fromAttrib = node.getAttribute("from");
        String textAttrib = node.getAttribute("text");
        if (fromAttrib.equals("") && textAttrib.equals("")) {
            throw new ActivitySpecificationException(this.getName(), "from|text");
        }
        if (!fromAttrib.equals("")) {
            this.mInternalInputs = new String[]{fromAttrib};
        } else if (!textAttrib.equals("")) {
            this.mString = textAttrib;
        }
    }

    private long parseOffset(String string, long fileLength) throws DAINumberFormatException, DAIOutOfBoundsException {
        long offset;
        if (string == null) {
            return -1L;
        }
        if (string.equalsIgnoreCase("start")) {
            return 0L;
        }
        if (string.equalsIgnoreCase("end")) {
            return fileLength;
        }
        try {
            offset = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new DAINumberFormatException(string);
        }
        if (offset < 0L) {
            throw new DAIOutOfBoundsException(offset, 0L);
        }
        return offset;
    }

    private long parseLength(String string, long fileLength, long offset) throws DAINumberFormatException, DAIOutOfBoundsException {
        int length;
        if (string == null) {
            return 0L;
        }
        if (string.equalsIgnoreCase("toEnd")) {
            return fileLength - offset;
        }
        try {
            length = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new DAINumberFormatException(string);
        }
        if (length < 0) {
            throw new DAIOutOfBoundsException(length, 0);
        }
        return length;
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            if (this.mInternalInputs.length > 0 && this.mInternalInputs[0] != null) {
                this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            }
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        super.initialise();
        try {
            this.mFile = new File(this.mTopDir, this.mFilename);
            this.mFileAccessProvider.validateWriteFile(this.mCredentials, this.mFile);
            FileUtilities.fileExists((File)this.mFile);
            FileUtilities.isFileWritable((File)this.mFile);
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "file", (Throwable)new DAIFileNotFoundException(new File(this.mFilename), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        try {
            this.mRaFile = new RandomAccessFile(this.mFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIFileNotFoundException(this.mFile));
        }
        try {
            this.mFileLength = this.mRaFile.length();
        }
        catch (IOException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIFileReadIOException(this.mFile));
        }
    }

    public synchronized void processBlock() {
        try {
            block21: {
                if (this.mType == 1) {
                    if (!this.mMultiline) {
                        this.performPerLineOffsetAndLength(this.mRaFile, this.mFileLength);
                    } else {
                        this.performPerFileOffsetAndLength(this.mRaFile, this.mFileLength);
                    }
                } else if (this.mType == 2) {
                    if (this.mAction == 3) {
                        this.setError(new ActivitySpecificationException(this.getName(), "regexp"));
                    }
                    if (this.mAction == 4) {
                        this.setError(new ActivitySpecificationException(this.getName(), "regexp"));
                    }
                    try {
                        if (!this.mMultiline) {
                            this.performPerLineRegexp(this.mRaFile, this.mFileLength);
                            break block21;
                        }
                        this.performPerFileRegexp(this.mRaFile, this.mFileLength);
                    }
                    catch (NonIncreasingSequenceException e) {
                        this.setError(new ActivitySpecificationException(this.getName(), "match", (Throwable)((Object)e)));
                    }
                    catch (MalformedRegexpPatternException e) {
                        this.setError(new ActivitySpecificationException(this.getName(), "regexp", (Throwable)((Object)e)));
                    }
                    catch (MalformedReplacementStringException e) {
                        this.setError(new ActivitySpecificationException(this.getName(), "regexp", (Throwable)((Object)e)));
                    }
                    catch (UnsupportedRegexpPatternFormatException e) {
                        this.setError(new ActivitySpecificationException(this.getName(), "regexp", (Throwable)((Object)e)));
                    }
                } else if (this.mType == 0) {
                    if (this.mAction != 3) {
                        this.setError(new ActivitySpecificationException(this.getName(), "locate"));
                    }
                    this.append(this.mRaFile, this.getStringInput());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing connection to " + this.mFile.toString());
            }
            this.mRaFile.close();
            this.setCompleted();
        }
        catch (ActivitySpecificationException e) {
            this.setError(e);
        }
        catch (OutOfMemoryException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
        this.mOutput.put((Object)"1");
    }

    private void performPerLineRegexp(RandomAccessFile raFile, long fileLength) throws NonIncreasingSequenceException, MalformedRegexpPatternException, MalformedReplacementStringException, UnsupportedRegexpPatternFormatException, IOException {
        String line;
        long prevOffset = 0L;
        while ((line = raFile.readLine()) != null) {
            long curOffset = raFile.getFilePointer();
            int matchNumber = 0;
            OroMatcher matcher = null;
            try {
                matcher = new OroPerl5Pattern(this.mRegexp).matcher();
            }
            catch (MalformedPatternException e) {
                throw new MalformedRegexpPatternException(this.mRegexp);
            }
            ((AbstractMatcher)matcher).setInput(line);
            int difference = 0;
            int index = 0;
            matcher.setSearchOffset(index);
            while (((AbstractMatcher)matcher).findNextMatch()) {
                int matcherStart = ((AbstractMatcher)matcher).startOffset();
                long offset = (long)matcherStart + prevOffset;
                long end = (long)((AbstractMatcher)matcher).endOffset() + prevOffset;
                long length = end - offset;
                if (this.mMatch.isMember(++matchNumber)) {
                    String string = this.performSubstitutions(this.getStringInput(), matcher);
                    this.performAction(raFile, this.mAction, offset, length, true, string);
                    difference = (int)((long)difference + ((long)string.length() - length));
                    line = this.replaceStringInString(line, matcherStart, (int)length, string);
                    ((AbstractMatcher)matcher).setInput(line);
                    index = matcherStart + string.length();
                } else {
                    index = ((AbstractMatcher)matcher).endOffset();
                }
                matcher.setSearchOffset(index);
            }
            raFile.seek(curOffset + (long)difference);
            prevOffset = curOffset + (long)difference;
        }
    }

    private void performPerFileRegexp(RandomAccessFile raFile, long fileLength) throws NonIncreasingSequenceException, MalformedRegexpPatternException, MalformedReplacementStringException, UnsupportedRegexpPatternFormatException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Regular Expression matching: Complete File");
        }
        String fileContents = FileWritingActivity.getFileContents(raFile);
        int matchNumber = 0;
        OroMatcher matcher = null;
        try {
            matcher = new OroPerl5Pattern(this.mRegexp).matcher();
        }
        catch (MalformedPatternException e) {
            throw new MalformedRegexpPatternException(this.mRegexp);
        }
        ((AbstractMatcher)matcher).setInput(fileContents);
        int index = 0;
        matcher.setSearchOffset(index);
        while (((AbstractMatcher)matcher).findNextMatch()) {
            int offset = ((AbstractMatcher)matcher).startOffset();
            int end = ((AbstractMatcher)matcher).endOffset();
            int length = end - offset;
            if (this.mMatch.isMember(++matchNumber)) {
                String string = this.performSubstitutions(this.getStringInput(), matcher);
                this.performAction(raFile, this.mAction, offset, length, false, string);
                fileContents = this.replaceStringInString(fileContents, offset, length, string);
                ((AbstractMatcher)matcher).setInput(fileContents);
                index = offset + string.length();
            } else {
                index = end;
            }
            matcher.setSearchOffset(index);
        }
    }

    private void performPerLineOffsetAndLength(RandomAccessFile raFile, long fileLength) throws ActivitySpecificationException, IOException {
        String line;
        long prevOffset = 0L;
        while ((line = this.readLine(raFile)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("line is " + line);
                LOG.debug("ptr: " + raFile.getFilePointer() + " vs " + raFile.length());
            }
            long offset = 0L;
            try {
                offset = this.parseOffset(this.mOffset, line.length());
            }
            catch (DAINumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)e);
            }
            catch (DAIOutOfBoundsException e) {
                throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)e);
            }
            long length = 0L;
            try {
                length = this.parseLength(this.mLength, line.length(), offset);
            }
            catch (DAINumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "length", (Throwable)e);
            }
            catch (DAIOutOfBoundsException e) {
                throw new ActivitySpecificationException(this.getName(), "length", (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("length is " + length + " for line \"" + line + "\" and offset " + offset);
            }
            long curOffset = raFile.getFilePointer();
            int difference = (int)((long)this.getStringInput().length() - length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("cur offset is " + curOffset);
                LOG.debug(" - difference is " + difference);
                LOG.debug(" - next 10 are: " + FileWritingActivity.getNextTenBytes(raFile));
            }
            if (length < 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring line \"" + line + "\" because offset = " + offset + " is beyond the end of it.");
                }
                prevOffset = curOffset;
                continue;
            }
            if (offset + length > (long)line.length()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring line \"" + line + "\" because (offset+length) = " + (offset + length) + " is longer than it.");
                }
                prevOffset = curOffset;
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(" - performing " + this.mAction + " from " + (prevOffset + offset) + " to length " + length + " with string " + this.getStringInput());
            }
            this.performAction(raFile, this.mAction, prevOffset + offset, length, true, this.getStringInput());
            if (LOG.isDebugEnabled()) {
                LOG.debug(" - rewinding to prevoffset (" + prevOffset + ")");
            }
            raFile.seek(prevOffset);
            LOG.debug(" - next 10 are: " + FileWritingActivity.getNextTenBytes(raFile));
            raFile.seek(curOffset + (long)difference);
            prevOffset = curOffset + (long)difference;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(" - seeking to " + (curOffset + (long)difference));
            LOG.debug(" - next 10 are: " + FileWritingActivity.getNextTenBytes(raFile));
        }
    }

    private void performPerFileOffsetAndLength(RandomAccessFile raFile, long fileLength) throws ActivitySpecificationException, IOException {
        long offset = 0L;
        try {
            offset = this.parseOffset(this.mOffset, fileLength);
        }
        catch (DAINumberFormatException e) {
            throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)e);
        }
        catch (DAIOutOfBoundsException e) {
            throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)e);
        }
        long length = 0L;
        try {
            length = this.parseLength(this.mLength, fileLength, offset);
        }
        catch (DAINumberFormatException e) {
            throw new ActivitySpecificationException(this.getName(), "length", (Throwable)e);
        }
        catch (DAIOutOfBoundsException e) {
            throw new ActivitySpecificationException(this.getName(), "length", (Throwable)e);
        }
        if (offset == -1L && this.mAction != 3) {
            throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)new DAIOutOfBoundsException(offset, 0L));
        }
        if (length == -1L && this.mAction != 4 && this.mAction != 1) {
            throw new ActivitySpecificationException(this.getName(), "length", (Throwable)new DAIOutOfBoundsException(length, 1L));
        }
        this.performAction(raFile, this.mAction, offset, length, false, this.getStringInput());
    }

    private String performSubstitutions(String string, AbstractMatcher matcher) throws MalformedReplacementStringException {
        if (string == null || string.length() == 0) {
            return string;
        }
        String[] groups = matcher.groups();
        SubstitutionStringParser parser = new SubstitutionStringParser(groups, string);
        return parser.readString();
    }

    private String replaceStringInString(String hostString, int offset, int length, String replacement) {
        String before = hostString.substring(0, offset);
        String after = hostString.substring(offset + length);
        return before + replacement + after;
    }

    private int getStepSize(long length) {
        int step = this.mOptimiseForTime ? 10000 : Math.min(10000, (int)(length / 10L));
        return step;
    }

    private void performAction(RandomAccessFile raFile, int type, long offset, long length, boolean perLine, String string) throws IOException {
        if (type == 1) {
            this.delete(raFile, offset, length);
        } else if (type == 2) {
            this.replace(raFile, offset, length, string);
        } else if (type == 4) {
            this.insert(raFile, offset, string);
        } else if (type == 3) {
            if (perLine) {
                this.insert(raFile, offset, string);
            } else {
                this.append(raFile, string);
            }
        }
    }

    private void append(RandomAccessFile raFile, String string) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending \"" + string + "\".");
        }
        this.replaceString(raFile, raFile.length(), 0L, string);
    }

    private void insert(RandomAccessFile raFile, long offset, String string) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inserting \"" + string + "\" at offset " + offset);
        }
        this.replaceString(raFile, offset, 0L, string);
    }

    private void delete(RandomAccessFile raFile, long offset, long length) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting offset " + offset + ", length " + length);
        }
        this.replaceString(raFile, offset, length, "");
    }

    private void replace(RandomAccessFile raFile, long offset, long length, String string) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Replacing offset " + offset + ", length " + length + " with string " + string);
        }
        this.replaceString(raFile, offset, length, string);
    }

    private String getStringInput() {
        String string = this.mString == null ? "" : this.mString;
        return this.mInput != null ? this.obtainInput() : string;
    }

    private String obtainInput() {
        if (this.mString != null && !this.mString.equals("")) {
            return this.mString;
        }
        StringBuffer repBuffer = new StringBuffer();
        while (this.mInput.hasNext()) {
            Object obj = this.mInput.next();
            if (obj instanceof String) {
                MemoryUtilities.checkMemory((String)((String)obj), (DAILogger)LOG);
                repBuffer.append((String)obj);
                continue;
            }
            if (obj instanceof byte[]) {
                MemoryUtilities.checkMemory((byte[])((byte[])obj), (DAILogger)LOG);
                repBuffer.append(new String((byte[])obj));
                continue;
            }
            if (obj instanceof Node) {
                MemoryUtilities.checkMemory((byte[])((byte[])obj), (DAILogger)LOG);
                repBuffer.append(XMLUtilities.xmlDOMToString((Node)((Node)obj)));
                continue;
            }
            repBuffer.append(obj.toString());
        }
        this.mString = repBuffer.toString();
        return repBuffer.toString();
    }

    private void replaceString(RandomAccessFile raFile, long offset, long length, String replacementString) throws IOException {
        int step = this.getStepSize(length);
        if ((long)replacementString.length() == length) {
            FileWritingActivity.overwriteString(raFile, offset, replacementString);
        } else if ((long)replacementString.length() > length) {
            FileWritingActivity.replaceWithLongerString(raFile, offset, length, replacementString, step);
        } else {
            FileWritingActivity.replaceWithShorterString(raFile, offset, length, replacementString, step);
        }
    }

    public static void overwriteString(RandomAccessFile raFile, long offset, String replacementString) throws IOException {
        raFile.seek(offset);
        raFile.write(replacementString.getBytes());
    }

    public static void replaceWithLongerString(RandomAccessFile raFile, long offset, long length, String replacementString, int step) throws IOException {
        long origLength = raFile.length();
        raFile.setLength(raFile.length() + (long)replacementString.length() - length);
        long newLength = raFile.length();
        int totalBytesRead = 0;
        while ((long)totalBytesRead < origLength - (offset + length)) {
            int bytesToRead = (int)Math.min(origLength - (offset + length) - (long)totalBytesRead, (long)step);
            byte[] b = new byte[bytesToRead];
            raFile.seek(origLength - (long)totalBytesRead - (long)bytesToRead);
            int bytesRead = raFile.read(b, 0, bytesToRead);
            raFile.seek(newLength - (long)totalBytesRead - (long)bytesToRead);
            raFile.write(b, 0, bytesRead);
            totalBytesRead += bytesRead;
        }
        FileWritingActivity.overwriteString(raFile, offset, replacementString);
    }

    public static void replaceWithShorterString(RandomAccessFile raFile, long offset, long length, String replacementString, int step) throws IOException {
        FileWritingActivity.overwriteString(raFile, offset, replacementString);
        int totalBytesRead = 0;
        while ((long)totalBytesRead < raFile.length() - (offset + length)) {
            int bytesToRead = (int)Math.min(raFile.length() - (offset + length + (long)totalBytesRead), (long)step);
            byte[] b = new byte[bytesToRead];
            raFile.seek(offset + length + (long)totalBytesRead);
            int bytesRead = raFile.read(b, 0, bytesToRead);
            raFile.seek(offset + (long)totalBytesRead + (long)replacementString.length());
            raFile.write(b, 0, bytesRead);
            totalBytesRead += bytesRead;
        }
        raFile.setLength(raFile.length() - length + (long)replacementString.length());
    }

    public static String getFileContents(RandomAccessFile raFile) throws IOException {
        int bytesRead;
        StringBuffer buf = new StringBuffer();
        byte[] b = new byte[1024];
        raFile.seek(0L);
        while ((bytesRead = raFile.read(b)) != -1) {
            MemoryUtilities.checkMemory((int)(bytesRead * 2), (DAILogger)LOG);
            buf.append(new String(b, 0, bytesRead));
            raFile.skipBytes(bytesRead);
        }
        return buf.toString();
    }

    public String readLine(RandomAccessFile raFile) throws IOException {
        long fp = raFile.getFilePointer();
        String line = raFile.readLine();
        if (fp == raFile.length() && (FileWritingActivity.charAt(raFile, fp - 2L) == 13 && FileWritingActivity.charAt(raFile, fp - 1L) == 10 || FileWritingActivity.charAt(raFile, fp - 1L) == 10)) {
            if (this.mAlreadyReturnedBlank) {
                return null;
            }
            this.mAlreadyReturnedBlank = true;
            return "";
        }
        return line;
    }

    public static int charAt(RandomAccessFile raFile, long pos) throws IOException {
        if (pos < 0L) {
            return 0;
        }
        long fp = raFile.getFilePointer();
        raFile.seek(pos);
        int c = raFile.read();
        raFile.seek(fp);
        return c;
    }

    private static String getNextTenBytes(RandomAccessFile raFile) throws IOException {
        long pos = raFile.getFilePointer();
        int num = 35;
        byte[] b = new byte[35];
        int bytesRead = raFile.read(b);
        raFile.seek(pos);
        if (bytesRead >= 0) {
            return new String(b, 0, bytesRead);
        }
        return "";
    }
}

