/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.files.AbstractFileActivity;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.DAIFileDeleteException;
import uk.org.ogsadai.common.files.DAIFileFoundException;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.DAIFileWriteIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public class FileManipulationActivity
extends AbstractFileActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)FileManipulationActivity.class);
    public static final int NONE = 0;
    public static final int MOVE = 1;
    public static final int COPY = 2;
    public static final int CREATE = 3;
    public static final int DELETE = 4;
    private int mType = 0;
    private String mTypeName = "none";
    private BlockWriter mOutput;
    private String mSource;
    private String mDestination;
    private File mSourceFile;
    private File mDestinationFile;

    public FileManipulationActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList deleteNodes;
        NodeList createNodes;
        NodeList copyNodes;
        NodeList moveNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "move");
        if (moveNodes.getLength() == 1) {
            Element node = (Element)moveNodes.item(0);
            this.mType = 1;
            this.mTypeName = "move";
            this.mDestination = node.getAttribute("to");
            this.mSource = node.getChildNodes().item(0).getNodeValue();
        }
        if ((copyNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "copy")).getLength() == 1) {
            Element node = (Element)copyNodes.item(0);
            this.mType = 2;
            this.mTypeName = "copy";
            this.mDestination = node.getAttribute("to");
            this.mSource = node.getChildNodes().item(0).getNodeValue();
        }
        if ((createNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "create")).getLength() == 1) {
            Element node = (Element)createNodes.item(0);
            this.mType = 3;
            this.mTypeName = "create";
            this.mDestination = null;
            this.mSource = node.getChildNodes().item(0).getNodeValue();
        }
        if ((deleteNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "delete")).getLength() == 1) {
            Element node = (Element)deleteNodes.item(0);
            this.mType = 4;
            this.mTypeName = "delete";
            this.mDestination = null;
            this.mSource = node.getChildNodes().item(0).getNodeValue();
        }
        if (this.mType == 0) {
            throw new ActivitySpecificationException(this.getName(), "copy|create|delete|move");
        }
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        this.mInternalOutputs = new String[]{output.getAttribute("name")};
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toString());
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        super.initialise();
        try {
            if (this.mSource != null) {
                this.mSourceFile = new File(this.mTopDir, this.mSource);
                this.mFileAccessProvider.validateReadFile(this.mCredentials, this.mSourceFile);
            }
            if (this.mDestination != null) {
                this.mDestinationFile = new File(this.mTopDir, this.mDestination);
                this.mFileAccessProvider.validateWriteFile(this.mCredentials, this.mDestinationFile);
            }
            if (this.mType == 4) {
                this.mFileAccessProvider.validateWriteFile(this.mCredentials, this.mSourceFile);
            }
            if (this.mType != 3) {
                FileUtilities.fileExists((File)this.mSourceFile);
            } else {
                FileUtilities.fileDoesntExist((File)this.mSourceFile);
            }
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIFileNotFoundException(new File(this.mSource), true));
        }
        catch (DAIFileFoundException e) {
            throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIFileFoundException(new File(this.mSource), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    public String toString() {
        switch (this.mType) {
            case 2: {
                return "Copy " + this.mSource + " to " + this.mDestination;
            }
            case 1: {
                return "Move " + this.mSource + " to " + this.mDestination;
            }
            case 3: {
                return "Create " + this.mSource;
            }
            case 4: {
                return "Delete " + this.mSource;
            }
        }
        return "Unknown action";
    }

    public void processBlock() {
        try {
            switch (this.mType) {
                case 3: {
                    this.create();
                    break;
                }
                case 2: {
                    this.copy();
                    break;
                }
                case 4: {
                    this.delete();
                    break;
                }
                case 1: {
                    this.move();
                    break;
                }
            }
            this.mOutput.put((Object)"1");
            this.setCompleted();
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private synchronized void copy() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            FileUtilities.fileExists((File)this.mSourceFile);
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIFileNotFoundException(new File(this.mSource), true));
        }
        File destParent = this.mDestinationFile.getParentFile();
        if (destParent != null) {
            try {
                FileUtilities.directoryExists((File)destParent);
            }
            catch (DAIDirectoryNotFoundException e) {
                throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIDirectoryNotFoundException(new File(this.mDestination), true));
            }
        }
        try {
            int bytes;
            FileInputStream inStream = new FileInputStream(this.mSourceFile);
            FileOutputStream outStream = new FileOutputStream(this.mDestinationFile);
            byte[] b = new byte[256];
            while ((bytes = inStream.read(b)) != -1) {
                outStream.write(b, 0, bytes);
            }
            outStream.close();
            inStream.close();
        }
        catch (IOException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIFileReadIOException(this.mSourceFile));
        }
    }

    private synchronized void move() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            FileUtilities.fileExists((File)this.mSourceFile);
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIFileNotFoundException(new File(this.mSource), true));
        }
        File destParent = this.mDestinationFile.getParentFile();
        if (destParent != null) {
            try {
                FileUtilities.directoryExists((File)destParent);
            }
            catch (DAIDirectoryNotFoundException e) {
                throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIDirectoryNotFoundException(new File(this.mDestination), true));
            }
        }
        if (!this.mSourceFile.renameTo(this.mDestinationFile)) {
            this.copy();
            this.delete();
        }
    }

    private synchronized void delete() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            FileUtilities.fileExists((File)this.mSourceFile);
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIFileNotFoundException(new File(this.mSource), true));
        }
        if (!this.mSourceFile.delete()) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIFileDeleteException(this.mSourceFile));
        }
    }

    private synchronized void create() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            FileUtilities.fileDoesntExist((File)this.mSourceFile);
        }
        catch (DAIFileFoundException e) {
            throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIFileFoundException(new File(this.mSource), true));
        }
        File newParent = this.mSourceFile.getParentFile();
        if (newParent != null) {
            try {
                FileUtilities.directoryExists((File)newParent);
            }
            catch (DAIDirectoryNotFoundException e) {
                throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIDirectoryNotFoundException(new File(this.mSource), true));
            }
        }
        try {
            if (!this.mSourceFile.createNewFile()) {
                throw new ActivitySpecificationException(this.getName(), this.mTypeName, (Throwable)new DAIFileFoundException(new File(this.mSource), true));
            }
        }
        catch (IOException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new DAIFileWriteIOException(this.mSourceFile));
        }
    }
}

