/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.files.AbstractFileActivity;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public class FileAccessActivity
extends AbstractFileActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)FileAccessActivity.class);
    private File mFile;
    private String mFilename;
    private boolean mBase64encode = false;
    private boolean mBinaryFile = true;
    private int mOffset = 0;
    private int mLength = -1;
    private BlockWriter mOutput;

    public FileAccessActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        Element lines;
        Element bytes;
        Node node = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "file").item(0);
        this.mFilename = node.getFirstChild().getNodeValue();
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        this.mInternalOutputs = new String[]{output.getAttribute("name")};
        String type = output.getAttribute("base64encode");
        if (type != null) {
            this.mBase64encode = type.equals("true") || type.equals("1");
        }
        if ((bytes = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "bytes").item(0)) != null) {
            this.mBinaryFile = true;
            this.mOffset = Integer.parseInt(bytes.getAttribute("offset"));
            this.mLength = Integer.parseInt(bytes.getAttribute("length"));
            if (this.mOffset < 0) {
                throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)new DAIOutOfBoundsException(this.mOffset, 0));
            }
            if (this.mLength < 0) {
                throw new ActivitySpecificationException(this.getName(), "length", (Throwable)new DAIOutOfBoundsException(this.mLength, 0));
            }
        }
        if ((lines = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "lines").item(0)) != null) {
            this.mBinaryFile = false;
            this.mOffset = Integer.parseInt(lines.getAttribute("offset"));
            this.mLength = Integer.parseInt(lines.getAttribute("length"));
            if (this.mOffset < 0) {
                throw new ActivitySpecificationException(this.getName(), "offset", (Throwable)new DAIOutOfBoundsException(this.mOffset, 0));
            }
            if (this.mLength < 0) {
                throw new ActivitySpecificationException(this.getName(), "length", (Throwable)new DAIOutOfBoundsException(this.mLength, 0));
            }
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        super.initialise();
        try {
            this.mFile = new File(this.mTopDir, this.mFilename);
            this.mFileAccessProvider.validateReadFile(this.mCredentials, this.mFile);
            FileUtilities.fileExists((File)this.mFile);
            FileUtilities.isFileReadable((File)this.mFile);
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "file", (Throwable)new DAIFileNotFoundException(new File(this.mFilename), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        StringBuffer buf = new StringBuffer();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("It looks like a binary file? " + this.mBinaryFile);
            }
            if (!this.mBinaryFile) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(this.mFile));
                int currentLine = 0;
                while ((line = reader.readLine()) != null) {
                    if (currentLine >= this.mOffset && currentLine < this.mOffset + this.mLength) {
                        if (this.mBase64encode) {
                            buf.append(new String(new Base64().encode((line + "\n").getBytes())));
                        } else {
                            buf.append(line + "\n");
                        }
                    }
                    ++currentLine;
                }
            } else {
                int bytes;
                FileInputStream inStream = new FileInputStream(this.mFile);
                inStream.skip(this.mOffset);
                byte[] b = new byte[24];
                int totalBytes = 0;
                if (this.mLength == -1) {
                    this.mLength = Integer.MAX_VALUE;
                }
                int length = Math.min(b.length, this.mLength - totalBytes);
                while (length > 0 && (bytes = inStream.read(b, 0, length)) != -1) {
                    String string;
                    length = Math.min(b.length, this.mLength - (totalBytes += bytes));
                    if (this.mBase64encode) {
                        byte[] plain = new byte[bytes];
                        System.arraycopy(b, 0, plain, 0, bytes);
                        byte[] encoded = new Base64().encode(plain);
                        string = new String(encoded);
                    } else {
                        string = new String(b, 0, bytes);
                    }
                    buf.append(string);
                }
            }
            this.mOutput.put((Object)buf.toString());
            this.setCompleted();
        }
        catch (FileNotFoundException e) {
            this.setError(new ActivitySpecificationException(this.getName(), "file", (Throwable)new DAIFileNotFoundException(new File(this.mFilename))));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIFileReadIOException(this.mFile)));
        }
    }
}

