/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.files;

import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.files.AbstractFileActivity;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public class DirectoryAccessActivity
extends AbstractFileActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2006. (c) The University of Edinburgh 2006";
    private String mDirectory;
    private File mFile;
    private BlockWriter mOutput;

    public DirectoryAccessActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        Node node = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "path").item(0);
        this.mDirectory = node == null ? "" : node.getFirstChild().getNodeValue();
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        this.mInternalOutputs = new String[]{output.getAttribute("name")};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        super.initialise();
        try {
            this.mFile = new File(this.mTopDir, this.mDirectory);
            this.mFileAccessProvider.validateReadFile(this.mCredentials, this.mFile);
            FileUtilities.directoryExists((File)this.mFile);
            FileUtilities.isDirectory((File)this.mFile);
            FileUtilities.isDirectoryReadable((File)this.mFile);
        }
        catch (DAIDirectoryNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "path", (Throwable)new DAIDirectoryNotFoundException(new File(this.mDirectory), true));
        }
        catch (DAIAuthorizationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
        }
        catch (AuthorizationExecutionException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (DataResourceUseException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        StringBuffer buf = new StringBuffer();
        buf.append("<list directory=\"");
        buf.append(this.mDirectory);
        buf.append("\">\n");
        File[] files = this.mFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                buf.append("<dir>");
                buf.append(files[i].getName());
                buf.append("</dir>\n");
                continue;
            }
            buf.append("<file>");
            buf.append(files[i].getName());
            buf.append("</file>\n");
        }
        buf.append("</list>\n");
        this.mOutput.put((Object)buf.toString());
        this.setCompleted();
    }
}

