/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.examples;

import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;

public class ExampleActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private BlockReader mInput;
    private BlockWriter mOutput;
    private String mConfiguration;

    public ExampleActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "myInput").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "myOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        Element configuration = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "myConfiguration").item(0);
        this.mConfiguration = configuration.getAttribute("value");
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (this.mInput.hasNext()) {
            Object inputBlock = this.mInput.next();
            try {
                this.mOutput.put(inputBlock);
            }
            catch (Exception e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
        } else {
            this.setCompleted();
        }
    }
}

