/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.examples;

import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;

public class DemoExternalInputActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DemoExternalInputActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;
    private int mNumInputBlocks;
    private String mStreamName;

    public DemoExternalInputActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "myOutput").item(0)).getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        Element configuration = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "nInputBlocks").item(0);
        this.mNumInputBlocks = Integer.parseInt(configuration.getAttribute("value"));
        configuration = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "streamName").item(0);
        this.mStreamName = configuration.getAttribute("value");
        this.mExternalInputs = new String[]{this.mStreamName};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.mInput = this.getSession().getExternalInput(this.mExternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        int sum = 0;
        for (int i = 0; i < this.mNumInputBlocks; ++i) {
            if (!this.mInput.hasNext()) continue;
            String block = (String)this.mInput.next();
            sum += Integer.parseInt(block);
        }
        try {
            this.getSession().removeExternalInput(this.mStreamName);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error while removing external input: " + this.mStreamName);
            }
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        this.mOutput.put((Object)("" + sum));
        this.setCompleted();
    }
}

