/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class OutputStreamActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)OutputStreamActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;

    public OutputStreamActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        String streamId = element.getAttribute("name");
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromLocal");
        String fromLocal = ((Element)list.item(0)).getAttribute("from");
        this.mInternalInputs = new String[]{fromLocal};
        this.mExternalOutputs = new String[]{streamId};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup delivery to outputStream with streamId: " + streamId + ", fromLocal with from: " + fromLocal);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.getSession().getExternalOutput(this.mExternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        if (this.mInput.hasNext()) {
            MemoryUtilities.logMemoryUsage((DAILogger)LOG);
            try {
                Object block = this.mInput.next();
                if (block instanceof String) {
                    MemoryUtilities.checkMemory((String)((String)block), (DAILogger)LOG);
                } else if (block instanceof byte[]) {
                    MemoryUtilities.checkMemory((int)((byte[])block).length, (DAILogger)LOG);
                }
                this.mOutput.put(block);
            }
            catch (OutOfMemoryException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
        } else {
            this.mOutput.close();
            this.setCompleted();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }
}

