/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;

public class InputStreamActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)InputStreamActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;

    public InputStreamActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        String streamId = element.getAttribute("name");
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "toLocal");
        String toLocal = ((Element)list.item(0)).getAttribute("name");
        this.mExternalInputs = new String[]{streamId};
        this.mInternalOutputs = new String[]{toLocal};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set up delivery from inputStream with streamId '" + streamId + "' and toLocal name '" + toLocal + "'");
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.getSession().getExternalInput(this.mExternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        if (this.mInput.hasNext()) {
            this.mOutput.put(this.mInput.next());
        } else {
            this.mOutput.close();
            this.setCompleted();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }
}

