/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.delivery.AbstractDeliverToAddressActivity;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAIMalformedURLException;
import uk.org.ogsadai.exception.DAIUnsupportedURLProtocolException;

public class DeliverToURLActivity
extends AbstractDeliverToAddressActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverToURLActivity.class);
    private URL mToURL = null;

    public DeliverToURLActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        NodeList toURLList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "toURL");
        toURLList = toURLList.item(0).getChildNodes();
        this.mToAddress = toURLList.item(0).getNodeValue().trim();
        try {
            this.mToURL = new URL(this.mToAddress);
        }
        catch (MalformedURLException e) {
            throw new ActivitySpecificationException(this.getName(), "toURL", (Throwable)new DAIMalformedURLException(this.mToAddress));
        }
        if (this.mToURL.getProtocol().equalsIgnoreCase("file")) {
            throw new ActivitySpecificationException(this.getName(), "toURL", (Throwable)new DAIUnsupportedURLProtocolException("file"));
        }
        super.setupInput((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromLocal").item(0));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup deliveryToURL with url: " + this.mToAddress + ", from: " + this.mInternalInputs[0]);
        }
    }

    public void processFirst() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to open stream for delivery to " + this.mToURL.toString());
            }
            URLConnection connection = this.mToURL.openConnection();
            connection.setDoInput(false);
            connection.setDoOutput(true);
            this.mOutputStream = connection.getOutputStream();
            this.mWriter = new OutputStreamWriter(this.mOutputStream);
        }
        catch (IOException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }
}

