/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.delivery.ServletStreamAccessException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.InternalFaultException;
import uk.org.ogsadai.exception.ServerException;
import uk.org.ogsadai.sessions.SessionID;

public class DeliverToStreamServlet
extends HttpServlet {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverToStreamServlet.class);
    private static Map streamTable = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getParameter("url");
        String resourceId = request.getParameter("resourceId");
        String sessionId = request.getParameter("sessionId");
        String streamId = request.getParameter("streamId");
        if (url == null || resourceId == null || sessionId == null || streamId == null) {
            ServletStreamAccessException accessEx = new ServletStreamAccessException(url, resourceId, sessionId, streamId);
            LOG.warn((Throwable)((Object)accessEx));
            throw new ServletException((Throwable)((Object)accessEx));
        }
        BlockReader input = null;
        DeliverToStreamServlet deliverToStreamServlet = this;
        synchronized (deliverToStreamServlet) {
            String index = DeliverToStreamServlet.getIndex(url, resourceId, sessionId, streamId);
            input = (BlockReader)streamTable.get(index);
            streamTable.remove(index);
        }
        if (input == null) {
            ServletStreamAccessException accessEx = new ServletStreamAccessException(url, resourceId, sessionId, streamId);
            LOG.warn((Throwable)((Object)accessEx));
            throw new ServletException((Throwable)((Object)accessEx));
        }
        BufferedOutputStream bos = null;
        try {
            response.setContentType("application/octet-stream");
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            while (true) {
                Object block;
                if ((block = input.next()) == null) {
                    continue;
                }
                if (block instanceof String) {
                    bos.write(((String)block).getBytes());
                    continue;
                }
                if (block instanceof byte[]) {
                    bos.write((byte[])block);
                    continue;
                }
                if (block instanceof Document) {
                    XMLUtilities.xmlDOMToStream((Node)((Document)block), (OutputStream)bos);
                    continue;
                }
                if (block instanceof Element) {
                    XMLUtilities.xmlDOMToStream((Node)((Element)block), (OutputStream)bos);
                    continue;
                }
                if (block instanceof DocumentFragment) {
                    XMLUtilities.xmlDOMToStream((Node)((DocumentFragment)block), (OutputStream)bos);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Delivering as String as type is unknown");
                }
                bos.write(block.toString().getBytes());
            }
        }
        catch (NoSuchElementException e) {
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            ServerException serverEx = new ServerException((Throwable)e);
            LOG.error((Throwable)serverEx, true);
            InternalFaultException faultEx = new InternalFaultException(serverEx);
            throw new ServletException((Throwable)faultEx);
        }
    }

    public static void addStream(String url, String resourceId, SessionID sessionId, String streamId, BlockReader reader) {
        String index = DeliverToStreamServlet.getIndex(url, resourceId, sessionId.toString(), streamId);
        streamTable.put(index, reader);
    }

    private static String getIndex(String url, String resourceId, String sessionId, String streamId) {
        return url + "/" + resourceId + "/" + sessionId + "/" + streamId;
    }
}

