/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.SynchronizedGrowablePipe;
import uk.org.ogsadai.activity.delivery.DeliverToStreamServlet;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.sessions.SessionID;

public class DeliverToStreamActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)DeliverToStreamActivity.class);
    private BlockReader mInput = null;
    private BlockWriter mOutput = null;
    private String mStreamId = null;

    public DeliverToStreamActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        this.mStreamId = element.getAttribute("name");
        NodeList fromLocalList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromLocal");
        NamedNodeMap fromLocalAttributes = fromLocalList.item(0).getAttributes();
        String fromLocalActivityName = fromLocalAttributes.getNamedItem("from").getNodeValue();
        this.mInternalInputs = new String[]{fromLocalActivityName};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup delivery to Stream with streamId: " + this.mStreamId + ", fromLocal with from: " + fromLocalActivityName);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processFirst() {
        SynchronizedGrowablePipe output = new SynchronizedGrowablePipe();
        this.mOutput = output;
        SynchronizedGrowablePipe mStreamReader = output;
        String url = this.mContext.getURL();
        String resource = this.mContext.getResourceID();
        SessionID sessionId = super.getSession().getID();
        DeliverToStreamServlet.addStream(url, resource, sessionId, this.mStreamId, (BlockReader)mStreamReader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data will be available at http://host:port/webapp/servlet-path/DeliverToStreamServlet?url=" + url + "&resourceId=" + resource + "&sessionId=" + sessionId + "&streamId=" + this.mStreamId);
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        try {
            Object currentObject = this.mInput.next();
            this.mOutput.put(currentObject);
        }
        catch (NoSuchElementException e) {
            this.mOutput.close();
            this.setCompleted();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }
}

