/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.delivery.UnknownSMTPHostException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIIOException;

public class DeliverToSMTPActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)DeliverToSMTPActivity.class);
    private String mServer = null;
    private List mToAddresses = new ArrayList();
    private String mSubject = null;
    private String mFromAddress = null;
    private BlockReader mInput;
    private BufferedReader mInputStream = null;
    private DataOutputStream mOutputStream = null;

    public DeliverToSMTPActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        NodeList fromLocalList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromLocal");
        NodeList toAddressList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "to");
        NodeList fromAddressList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "from");
        NodeList subjectList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "subject");
        NodeList serverList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "server");
        NamedNodeMap fromLocalAttributes = fromLocalList.item(0).getAttributes();
        String fromLocalActivityName = fromLocalAttributes.getNamedItem("from").getNodeValue();
        for (int i = 0; i < toAddressList.getLength(); ++i) {
            NodeList addresses = toAddressList.item(i).getChildNodes();
            this.mToAddresses.add(addresses.item(0).getNodeValue());
        }
        fromAddressList = fromAddressList.item(0).getChildNodes();
        this.mFromAddress = fromAddressList.item(0).getNodeValue();
        subjectList = subjectList.item(0).getChildNodes();
        this.mSubject = subjectList.item(0).getNodeValue();
        serverList = serverList.item(0).getChildNodes();
        this.mServer = serverList.item(0).getNodeValue();
        this.mInternalInputs = new String[]{fromLocalActivityName};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup delivery to SMTP to addresses: " + this.mToAddresses + ", from: " + this.mFromAddress + ", with subject: " + this.mSubject + ", using server: " + this.mServer);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processFirst() {
        try {
            Socket socket = new Socket(this.mServer, 25);
            this.mInputStream = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.mOutputStream = new DataOutputStream(socket.getOutputStream());
            if (LOG.isDebugEnabled()) {
                LOG.debug("First line: " + this.mInputStream.readLine());
            }
            this.mOutputStream.writeBytes("MAIL FROM: " + this.mFromAddress + "\n");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Second line: " + this.mInputStream.readLine());
            }
            Iterator iterator = this.mToAddresses.iterator();
            while (iterator.hasNext()) {
                String mToAddress = (String)iterator.next();
                this.mOutputStream.writeBytes("RCPT TO: " + mToAddress + "\n");
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Third line: " + this.mInputStream.readLine());
            }
            this.mOutputStream.writeBytes("DATA\n");
            this.mOutputStream.writeBytes("To: " + this.listToCommaSeparatedString(this.mToAddresses) + "\n");
            this.mOutputStream.writeBytes("From: " + this.mFromAddress + "\n");
            this.mOutputStream.writeBytes("Subject: " + this.mSubject + "\n");
        }
        catch (UnknownHostException e) {
            this.setError(new ActivitySpecificationException(this.getName(), "server", (Throwable)((Object)new UnknownSMTPHostException(this.mServer))));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering processBlock");
        }
        try {
            while (this.mInput.hasNext()) {
                Object currentObject = this.mInput.next();
                if (currentObject instanceof String) {
                    this.mOutputStream.writeBytes((String)currentObject);
                    continue;
                }
                if (currentObject instanceof byte[]) {
                    this.mOutputStream.write((byte[])currentObject);
                    continue;
                }
                if (currentObject instanceof Node) {
                    XMLUtilities.xmlDOMToStream((Node)((Node)currentObject), (OutputStream)this.mOutputStream);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Delivering Object.toString() as type is unknown");
                }
                this.mOutputStream.writeBytes(currentObject.toString());
            }
            this.mOutputStream.writeBytes("\n");
            this.mOutputStream.writeBytes(".\n");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Penultimate line: " + this.mInputStream.readLine());
                LOG.debug("Last line: " + this.mInputStream.readLine());
            }
            this.mOutputStream.writeBytes("QUIT\n");
            this.mOutputStream.close();
            this.setCompleted();
        }
        catch (XMLDocumentException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
        catch (XMLParseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    private String listToCommaSeparatedString(List list) {
        StringBuffer buf = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String item = iterator.next().toString();
            buf.append(item);
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

