/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyValueException;
import uk.org.ogsadai.common.properties.StaticProperty;
import uk.org.ogsadai.sessions.Session;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionNames;

public class DeliverToResourcePropertyActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverToResourcePropertyActivity.class);
    private BlockReader mInput;
    private QName mResourcePropName;
    private boolean mIsSessionSpecific;
    private StringBuffer mBuffer;

    public DeliverToResourcePropertyActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "input").item(0)).getAttribute("from");
        this.mInternalInputs = new String[]{inputName};
        Element resProp = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "resourceProperty").item(0);
        String localName = resProp.getAttribute("name");
        String namespace = resProp.getAttribute("ns");
        this.mResourcePropName = new QName(namespace, localName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("DeliverToResourceProperty: property to write to is: " + this.mResourcePropName);
        }
        String sessionSpecific = resProp.getAttribute("sessionSpecific");
        this.mIsSessionSpecific = Boolean.valueOf(sessionSpecific);
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mBuffer = new StringBuffer();
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (this.mInput.hasNext()) {
            Object inputBlock = this.mInput.next();
            if (inputBlock instanceof String) {
                this.mBuffer.append(inputBlock);
            } else {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(inputBlock.getClass().getName())));
            }
        } else {
            Session session = this.getSession();
            QName propName = this.mResourcePropName;
            if (this.mIsSessionSpecific) {
                propName = SessionNames.createSessionSpecifcResourcePropertyName((QName)this.mResourcePropName, (SessionID)session.getID());
            }
            Properties resourceProperties = session.getProperties();
            try {
                StaticProperty resourceProp = new StaticProperty();
                resourceProp.setName(propName);
                resourceProp.setValue((Object)this.mBuffer.toString());
                resourceProperties.put((Property)resourceProp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DeliverToResourceProperty: setting property " + propName + " to value: " + this.mBuffer.toString());
                }
                this.setCompleted();
            }
            catch (PropertyValueException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
        }
    }
}

