/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.delivery.AbstractDeliverToAddressActivity;
import uk.org.ogsadai.common.files.DAIFileNotFileException;
import uk.org.ogsadai.common.files.DAIFileWriteIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;

public class DeliverToFileActivity
extends AbstractDeliverToAddressActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverToFileActivity.class);
    private File mToFile = null;

    public DeliverToFileActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        Node node = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "toFile").item(0);
        this.mToAddress = node.getFirstChild().getNodeValue().trim();
        this.mToFile = new File(this.mToAddress);
        if (this.mToFile.isDirectory()) {
            throw new ActivitySpecificationException(this.getName(), "toFile", (Throwable)new DAIFileNotFileException(this.mToFile));
        }
        super.setupInput((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromLocal").item(0));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set up deliveryToFile with path: " + this.mToAddress + ", with from: " + this.mInternalInputs[0]);
        }
    }

    public void processFirst() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to open stream for delivery to " + this.mToFile.toString());
            }
            this.mToFile.createNewFile();
            FileUtilities.isFileWritable((File)this.mToFile);
            this.mOutputStream = new FileOutputStream(this.mToFile);
            this.mWriter = new OutputStreamWriter(this.mOutputStream);
        }
        catch (DAIFileWriteIOException e) {
            this.setError(new ActivitySpecificationException(this.getName(), "toFile", (Throwable)e));
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
    }
}

