/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class DeliverToAttachmentActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverToAttachmentActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;
    private static final int STRING_DATA = 0;
    private static final int BINARY_DATA = 1;
    private static final int FILE_DATA = 2;
    private int returnDataType;
    private StringBuffer mStringBuffer;
    private ArrayList mByteBuffer;
    private File mFileData;

    public DeliverToAttachmentActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "input").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (this.mInput.hasNext()) {
            Object inputBlock = this.mInput.next();
            if (inputBlock instanceof String) {
                if (this.mStringBuffer == null) {
                    this.mStringBuffer = new StringBuffer();
                    this.returnDataType = 0;
                }
                this.mStringBuffer.append(inputBlock);
            } else if (inputBlock instanceof byte[]) {
                if (this.mByteBuffer == null) {
                    this.mByteBuffer = new ArrayList();
                    this.returnDataType = 1;
                }
                this.mByteBuffer.add(inputBlock);
            } else if (inputBlock instanceof File) {
                this.mFileData = (File)inputBlock;
                this.returnDataType = 2;
            } else {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(inputBlock.getClass().getName())));
            }
        } else {
            AttachmentManager attManager = this.mContext.getAttachmentManager();
            String contentID = null;
            try {
                switch (this.returnDataType) {
                    case 0: {
                        if (this.mStringBuffer == null) break;
                        contentID = attManager.addNewPlainText(this.mStringBuffer.toString());
                        break;
                    }
                    case 1: {
                        if (this.mByteBuffer == null) break;
                        byte[] gatheredBytes = DeliverToAttachmentActivity.gatherBytes(this.mByteBuffer);
                        contentID = attManager.addNewOctetStream(gatheredBytes);
                        break;
                    }
                    case 2: {
                        if (this.mFileData == null) break;
                        contentID = attManager.addFile(this.mFileData);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            if (null != contentID) {
                this.mOutput.put((Object)contentID);
            }
            this.setCompleted();
        }
    }

    protected static byte[] gatherBytes(List byteArrays) {
        int totalLength = 0;
        int listSize = byteArrays.size();
        int[] byteArraysSizes = new int[listSize];
        for (int i = 0; i < byteArrays.size(); ++i) {
            byteArraysSizes[i] = ((byte[])byteArrays.get(i)).length;
            totalLength += byteArraysSizes[i];
        }
        byte[] gatheredBytes = new byte[totalLength];
        int currentPos = 0;
        for (int i = 0; i < byteArrays.size(); ++i) {
            System.arraycopy((byte[])byteArrays.get(i), 0, gatheredBytes, currentPos, byteArraysSizes[i]);
            currentPos += byteArraysSizes[i];
        }
        return gatheredBytes;
    }
}

