/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.delivery.AbstractDeliverFromAddressActivity;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAIMalformedURLException;
import uk.org.ogsadai.exception.DAIUnsupportedURLProtocolException;

public class DeliverFromURLActivity
extends AbstractDeliverFromAddressActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverFromURLActivity.class);
    private URL mFromURL = null;

    public DeliverFromURLActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        Node node = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromURL").item(0);
        this.mFromAddress = node.getFirstChild().getNodeValue().trim();
        try {
            this.mFromURL = new URL(this.mFromAddress);
        }
        catch (MalformedURLException e) {
            throw new ActivitySpecificationException(this.getName(), "fromURL", (Throwable)new DAIMalformedURLException(this.mFromAddress));
        }
        if (this.mFromURL.getProtocol().equalsIgnoreCase("file")) {
            throw new ActivitySpecificationException(this.getName(), "fromURL", (Throwable)new DAIUnsupportedURLProtocolException("file"));
        }
        try {
            super.setupBlocking((Element)node);
        }
        catch (ActivityExecutionException e) {
            throw new ActivityCreationException(this.getName(), e.getCause());
        }
        super.setupOutput((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "toLocal").item(0));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set up delivery from url: " + this.mFromAddress + ", to internal output: " + this.mInternalOutputs[0]);
        }
    }

    public void processFirst() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to open stream for delivery from " + this.mFromURL.toString());
            }
            URLConnection connection = this.mFromURL.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            this.mFromInputStream = connection.getInputStream();
        }
        catch (IOException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }
}

