/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.File;
import java.io.FileInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.delivery.AbstractDeliverFromAddressActivity;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;

public class DeliverFromFileActivity
extends AbstractDeliverFromAddressActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverFromFileActivity.class);
    private final File mFromFile;

    public DeliverFromFileActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        Node node = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fromFile").item(0);
        this.mFromAddress = node.getFirstChild().getNodeValue().trim();
        this.mFromFile = new File(this.mFromAddress);
        try {
            FileUtilities.fileExists((File)this.mFromFile);
        }
        catch (DAIFileNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), "fromFile", (Throwable)e);
        }
        try {
            super.setupBlocking((Element)node);
        }
        catch (ActivityExecutionException e) {
            throw new ActivityCreationException(this.getName(), e.getCause());
        }
        super.setupOutput((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "toLocal").item(0));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set up delivery from file: " + this.mFromAddress + ", to internal output: " + this.mInternalOutputs[0]);
        }
    }

    public void processFirst() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to open stream for delivery from " + this.mFromFile.toString());
            }
            FileUtilities.isFileReadable((File)this.mFromFile);
            this.mFromInputStream = new FileInputStream(this.mFromFile);
        }
        catch (DAIFileReadIOException e) {
            this.setError(new ActivitySpecificationException(this.getName(), "fromFile", (Throwable)e));
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
    }
}

