/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.delivery.AbstractDTDeliveryActivity;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIIOException;

public abstract class AbstractDeliverToDTActivity
extends AbstractDTDeliveryActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)AbstractDeliverToDTActivity.class);
    private BlockReader mInput;

    public AbstractDeliverToDTActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        super.getDeliverySettings(element, "toGDT", "fromLocal", "from");
        this.mInternalInputs = new String[]{this.mLocalStream};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        block20: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processBlock: start");
            }
            try {
                if (this.mBlockMode) {
                    Object block;
                    while (this.mInput.hasNext()) {
                        MemoryUtilities.logMemoryUsage((DAILogger)LOG);
                        block = this.mInput.next();
                        this.putBlock(block);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("All blocks delivered");
                    }
                    this.putClosingBlock();
                    super.setCompleted();
                    block = null;
                    break block20;
                }
                Object data = null;
                try {
                    StringBuffer buffer = new StringBuffer();
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    while (this.mInput.hasNext()) {
                        MemoryUtilities.logMemoryUsage((DAILogger)LOG);
                        Object block = this.mInput.next();
                        if (block instanceof String) {
                            MemoryUtilities.checkMemory((String)((String)block), (DAILogger)LOG);
                            buffer.append((String)block);
                            continue;
                        }
                        if (block instanceof Node) {
                            String blockString = XMLUtilities.xmlDOMToString((Node)((Node)block));
                            MemoryUtilities.checkMemory((String)blockString, (DAILogger)LOG);
                            buffer.append(blockString);
                            continue;
                        }
                        if (block instanceof byte[]) {
                            MemoryUtilities.checkMemory((byte[])((byte[])block), (DAILogger)LOG);
                            try {
                                bytes.write((byte[])block);
                                bytes.flush();
                                continue;
                            }
                            catch (IOException e) {
                                throw new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e));
                            }
                        }
                        LOG.warn((Throwable)new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(block.getClass().getName())));
                        buffer.append(block);
                    }
                    if (buffer.length() > 0) {
                        MemoryUtilities.checkMemory((StringBuffer)buffer, (DAILogger)LOG);
                        data = buffer.toString();
                    } else if (bytes.size() > 0) {
                        MemoryUtilities.checkMemory((ByteArrayOutputStream)bytes, (DAILogger)LOG);
                        data = bytes.toByteArray();
                    }
                    buffer = null;
                    Object var3_7 = null;
                }
                catch (OutOfMemoryException e) {
                    throw new ActivityExecutionException(super.getName(), (Throwable)e);
                }
                this.putFully(data);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Data delivered");
                }
                super.setCompleted();
                data = null;
            }
            catch (ActivitySpecificationException e) {
                super.setError((Throwable)e);
            }
            catch (ActivityExecutionException e) {
                super.setError((Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }

    protected abstract void putFully(Object var1) throws ActivitySpecificationException, ActivityExecutionException;

    protected abstract void putBlock(Object var1) throws ActivitySpecificationException, ActivityExecutionException;

    protected abstract void putClosingBlock() throws ActivitySpecificationException, ActivityExecutionException;
}

