/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIIOException;

public abstract class AbstractDeliverToAddressActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger((Class)AbstractDeliverToAddressActivity.class);
    protected BlockReader mInput;
    protected OutputStream mOutputStream = null;
    protected Writer mWriter = null;
    protected String mToAddress = null;

    public AbstractDeliverToAddressActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
    }

    protected void setupInput(Element fromElement) {
        String fromLocal = fromElement.getAttribute("from");
        this.mInternalInputs = new String[]{fromLocal};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public abstract void processFirst();

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering processBlock");
            LOG.debug("Commencing delivery to " + this.mToAddress);
        }
        try {
            while (this.mInput.hasNext()) {
                Object currentObject = this.mInput.next();
                if (currentObject instanceof String) {
                    this.mWriter.write((String)currentObject);
                } else if (currentObject instanceof byte[]) {
                    this.mOutputStream.write((byte[])currentObject);
                } else if (currentObject instanceof Node) {
                    XMLUtilities.xmlDOMToStream((Node)((Node)currentObject), (OutputStream)this.mOutputStream);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Delivering Object.toString() as type is unknown");
                    }
                    this.mWriter.write(currentObject.toString());
                }
                this.mWriter.flush();
                this.mOutputStream.flush();
                currentObject = null;
            }
        }
        catch (XMLDocumentException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
        catch (XMLParseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
        try {
            this.mWriter.close();
            this.mOutputStream.close();
            this.setCompleted();
        }
        catch (IOException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }
}

