/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.delivery.AbstractDTDeliveryActivity;
import uk.org.ogsadai.client.toolkit.service.ServiceConstants;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public abstract class AbstractDeliverFromDTActivity
extends AbstractDTDeliveryActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)AbstractDeliverFromDTActivity.class);
    private BlockWriter mOutput;
    protected int mNumBlocks = 1;

    public AbstractDeliverFromDTActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        super.getDeliverySettings(element, "fromGDT", "toLocal", "name");
        this.mInternalOutputs = new String[]{this.mLocalStream};
        NamedNodeMap fromAttrs = this.mDeliveryNode.getAttributes();
        Node numBlocksAttr = fromAttrs.getNamedItem("numberOfBlocks");
        if (this.mBlockMode && numBlocksAttr != null) {
            String numBlocksStr = numBlocksAttr.getNodeValue();
            try {
                this.mNumBlocks = Integer.parseInt(numBlocksAttr.getNodeValue());
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "numberOfBlocks", (Throwable)new DAINumberFormatException(numBlocksStr));
            }
            if (this.mNumBlocks <= 0) {
                throw new ActivitySpecificationException(this.getName(), "numberOfBlocks", (Throwable)new DAIOutOfBoundsException(this.mNumBlocks, 1));
            }
        }
        if (LOG.isDebugEnabled()) {
            if (this.mBlockMode) {
                LOG.debug("  Number of blocks: " + this.mNumBlocks);
            } else {
                LOG.debug("  Number of blocks: ALL");
            }
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        try {
            Object data = null;
            data = this.mBlockMode ? this.getNBlocks(this.mNumBlocks) : this.getFully();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received block of data: " + data);
            }
            if (data.equals(ServiceConstants.NO_MORE_DATA) || data.equals(ServiceConstants.NO_MORE_DATA.toString())) {
                this.mOutput.close();
                super.setCompleted();
            } else {
                this.mOutput.put(data);
                if (!this.mBlockMode) {
                    this.mOutput.close();
                    super.setCompleted();
                }
            }
        }
        catch (ActivitySpecificationException e) {
            super.setError((Throwable)e);
        }
        catch (ActivityExecutionException e) {
            super.setError((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }

    protected abstract Object getFully() throws ActivitySpecificationException, ActivityExecutionException;

    protected abstract Object getNBlocks(int var1) throws ActivitySpecificationException, ActivityExecutionException;
}

