/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public abstract class AbstractDeliverFromAddressActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)AbstractDeliverFromAddressActivity.class);
    protected String mFromAddress = null;
    protected InputStream mFromInputStream = null;
    protected boolean mBlockMode = false;
    protected byte[] mBuffer;
    protected final ByteArrayOutputStream mByteBuffer = new ByteArrayOutputStream();
    protected BlockWriter mOutput;

    public AbstractDeliverFromAddressActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
    }

    protected void setupBlocking(Element fromElement) throws ActivitySpecificationException, ActivityExecutionException {
        String blockSizeString = fromElement.getAttribute("blockSizeInBytes");
        if (!blockSizeString.equals("")) {
            this.mBlockMode = true;
            int blockSize = 0;
            try {
                blockSize = Integer.parseInt(blockSizeString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "blockSizeInBytes", (Throwable)new DAINumberFormatException(blockSizeString));
            }
            if (blockSize <= 0) {
                throw new ActivitySpecificationException(this.getName(), "blockSizeInBytes", (Throwable)new DAIOutOfBoundsException(blockSize, 1));
            }
            try {
                MemoryUtilities.checkMemory((int)blockSize, (DAILogger)LOG);
            }
            catch (OutOfMemoryException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            this.mBuffer = new byte[blockSize];
        } else {
            this.mBlockMode = false;
            this.mBuffer = new byte[4096];
        }
    }

    protected void setupOutput(Element toElement) {
        String toLocal = toElement.getAttribute("name");
        this.mInternalOutputs = new String[]{toLocal};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public abstract void processFirst();

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering processBlock");
        }
        MemoryUtilities.logMemoryUsage((DAILogger)LOG);
        int bytesRead = 0;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Delivering data from input stream");
            }
            do {
                if ((bytesRead = this.mFromInputStream.read(this.mBuffer)) == -1) continue;
                MemoryUtilities.checkMemory((int)bytesRead, (DAILogger)LOG);
                this.mByteBuffer.write(this.mBuffer, 0, bytesRead);
            } while (bytesRead != -1 && !this.mBlockMode);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Data has been received. About to write " + this.mByteBuffer.size() + " bytes to activity output.");
            }
            if (this.mByteBuffer.size() > 0) {
                MemoryUtilities.checkMemory((int)bytesRead, (DAILogger)LOG);
                this.mOutput.put((Object)this.mByteBuffer.toByteArray());
            }
            if (bytesRead == -1 || !this.mBlockMode) {
                this.mFromInputStream.close();
                this.mFromInputStream = null;
                this.mByteBuffer.close();
                this.mOutput.close();
                this.setCompleted();
            } else if (this.mBlockMode) {
                this.mByteBuffer.reset();
            }
        }
        catch (IOException e) {
            this.setError((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
        catch (OutOfMemoryException e) {
            this.setError((Throwable)new ActivityExecutionException(this.getName(), (Throwable)e));
        }
    }
}

