/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.common.msgs.DAILogger;

public abstract class AbstractDTDeliveryActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)AbstractDTDeliveryActivity.class);
    protected String mServiceURL = null;
    protected String mResourceID = null;
    protected String mStreamID = null;
    protected boolean mBlockMode = true;
    protected String mLocalStream = null;
    protected Node mDeliveryNode = null;
    protected String mServiceType = "unknown";

    public AbstractDTDeliveryActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
    }

    protected abstract void processBlock();

    protected void getDeliverySettings(Element activity, String targetNode, String localStreamNode, String localStreamAttr) {
        Node serviceTypeNode;
        NodeList localStreamList = activity.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", localStreamNode);
        NamedNodeMap localAttrs = localStreamList.item(0).getAttributes();
        this.mLocalStream = localAttrs.getNamedItem(localStreamAttr).getNodeValue();
        NodeList targetList = activity.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", targetNode);
        this.mDeliveryNode = targetList.item(0);
        NodeList deliveryNodes = this.mDeliveryNode.getChildNodes();
        this.mServiceURL = deliveryNodes.item(0).getNodeValue().trim();
        NamedNodeMap deliveryAttributes = this.mDeliveryNode.getAttributes();
        Node nameNode = deliveryAttributes.getNamedItem("resourceName");
        this.mResourceID = nameNode.getNodeValue().trim();
        this.mStreamID = deliveryAttributes.getNamedItem("streamId").getNodeValue();
        Node modeNode = deliveryAttributes.getNamedItem("mode");
        if (modeNode != null && modeNode.getNodeValue().equals("full")) {
            this.mBlockMode = false;
        }
        if ((serviceTypeNode = deliveryAttributes.getNamedItem("serviceType")) != null) {
            this.mServiceType = serviceTypeNode.getNodeValue().trim();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup");
            LOG.debug("  Local activity stream :" + this.mLocalStream);
            LOG.debug("  Target service:" + this.mServiceURL);
            LOG.debug("  Target service type:" + this.mServiceType);
            LOG.debug("  Target data service resource:" + this.mResourceID);
            LOG.debug("  Target stream:" + this.mStreamID);
            LOG.debug("  Block transfer?:" + this.mBlockMode);
        }
    }

    protected boolean isServiceWSRF() {
        return this.mServiceType.equals("wsrf");
    }

    protected boolean isServiceWSI() {
        return this.mServiceType.equals("wsi");
    }

    protected boolean isServiceUnknown() {
        return this.mServiceType.equals("unknown");
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
    }

    protected void processFirst() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting up delivery to URL: " + this.mServiceURL);
        }
        try {
            this.contactTargetService();
        }
        catch (Exception e) {
            super.setError((Throwable)e);
        }
    }

    protected abstract void contactTargetService() throws ActivitySpecificationException, ActivityExecutionException;
}

