/*
 * Decompiled with CFR 0.152.
 */
package org.globus.interop.widget.test;

import com.widgets.CreateWidget;
import com.widgets.CreateWidgetResponse;
import com.widgets.GenerateNotification;
import com.widgets.WidgetNotificationPortType;
import com.widgets.WidgetPortType;
import com.widgets.service.WidgetNotificationServiceAddressingLocator;
import com.widgets.service.WidgetServiceAddressingLocator;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPElement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.types.URI;
import org.globus.interop.widget.Widget;
import org.globus.interop.widget.WidgetNotificationService;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.core.notification.service.SubscriptionManagerServiceAddressingLocator;
import org.globus.wsrf.core.tests.interop.CreateNotificationConsumer;
import org.globus.wsrf.core.tests.interop.NotificationConsumerFactory;
import org.globus.wsrf.core.tests.interop.service.NotificationConsumerFactoryServiceAddressingLocator;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.test.GridTestCase;
import org.oasis.wsn.GetCurrentMessage;
import org.oasis.wsn.GetCurrentMessageResponse;
import org.oasis.wsn.PauseSubscription;
import org.oasis.wsn.ResumeSubscription;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.properties.DeleteType;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.InsertType;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.SetResourceProperties_Element;
import org.oasis.wsrf.properties.UpdateType;

public class InteropTest
extends GridTestCase {
    private WidgetServiceAddressingLocator locator = new WidgetServiceAddressingLocator();
    private WidgetNotificationServiceAddressingLocator notificationLocator = new WidgetNotificationServiceAddressingLocator();
    private SubscriptionManagerServiceAddressingLocator subscriptionManagerLocator = new SubscriptionManagerServiceAddressingLocator();
    private static String serviceAddress = null;
    private static String notificationServiceAddress = null;
    private static String consumerFactoryServiceAddress = null;
    private static String queryString = "boolean(/*/*[namespace-uri()='http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd' and local-name()='TerminationTime'])";
    static /* synthetic */ Class class$org$globus$interop$widget$test$InteropTest;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$lang$String;

    public InteropTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    public static void main(String[] args) {
        TestSuite testSuite = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-service")) {
                serviceAddress = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-notificationService")) {
                notificationServiceAddress = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-consumerService")) {
                consumerFactoryServiceAddress = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-query")) {
                queryString = args[++i];
                continue;
            }
            if (testSuite == null) {
                testSuite = new TestSuite();
            }
            testSuite.addTest((Test)new InteropTest(args[i]));
        }
        if (testSuite == null) {
            testSuite = new TestSuite(class$org$globus$interop$widget$test$InteropTest == null ? (class$org$globus$interop$widget$test$InteropTest = InteropTest.class$("org.globus.interop.widget.test.InteropTest")) : class$org$globus$interop$widget$test$InteropTest);
        }
        TestRunner.run(testSuite);
    }

    private String getServiceAddress() {
        if (serviceAddress != null) {
            return serviceAddress;
        }
        if (TEST_CONTAINER == null) {
            return "http://127.0.0.1:8080/wsrf/services/WidgetService";
        }
        return TEST_CONTAINER.getBaseURL() + "WidgetService";
    }

    private String getNotificationServiceAddress() {
        if (notificationServiceAddress != null) {
            return notificationServiceAddress;
        }
        if (TEST_CONTAINER == null) {
            return "http://127.0.0.1:8080/wsrf/services/WidgetNotificationService";
        }
        return TEST_CONTAINER.getBaseURL() + "WidgetNotificationService";
    }

    private String getConsumerFactoryServiceAddress() {
        if (consumerFactoryServiceAddress != null) {
            return consumerFactoryServiceAddress;
        }
        if (TEST_CONTAINER == null) {
            return "http://127.0.0.1:8080/wsrf/services/NotificationConsumerFactoryService";
        }
        return TEST_CONTAINER.getBaseURL() + "NotificationConsumerFactoryService";
    }

    private void destroySubscription(EndpointReferenceType subscriptionEPR) throws ServiceException, RemoteException {
        SubscriptionManager manager = this.subscriptionManagerLocator.getSubscriptionManagerPort(subscriptionEPR);
        manager.destroy(new Destroy());
    }

    private EndpointReferenceType createResource() throws Exception {
        URL endpoint = new URL(this.getServiceAddress());
        WidgetPortType port = this.locator.getWidgetPortTypePort(endpoint);
        CreateWidgetResponse response = port.createWidget(new CreateWidget());
        return response.getEndpointReference();
    }

    public void testScenario1() throws Exception {
        URL endpoint = new URL(this.getServiceAddress());
        EndpointReferenceType rs = this.createResource();
        InteropTest.assertTrue((rs != null ? 1 : 0) != 0);
        InteropTest.assertTrue((rs.getAddress() != null ? 1 : 0) != 0);
        String address = rs.getAddress().toString();
        InteropTest.assertTrue((boolean)address.endsWith(endpoint.getPath()));
        ReferencePropertiesType props = rs.getProperties();
        InteropTest.assertTrue((props.get_any() != null ? 1 : 0) != 0);
        InteropTest.assertTrue((props.get_any().length > 0 ? 1 : 0) != 0);
    }

    public void testScenario2() throws Exception {
        EndpointReferenceType endpoint = this.createResource();
        WidgetPortType port = this.locator.getWidgetPortTypePort(endpoint);
        port.destroy(new Destroy());
    }

    public void testScenario3() throws Exception {
        EndpointReferenceType endpoint = this.createResource();
        WidgetPortType port = this.locator.getWidgetPortTypePort(endpoint);
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        SetTerminationTime request = new SetTerminationTime();
        request.setRequestedTerminationTime(termTime);
        SetTerminationTimeResponse response = port.setTerminationTime(request);
        Calendar newTermTime = response.getNewTerminationTime();
        System.out.println("requested: " + termTime.getTime());
        System.out.println("scheduled: " + newTermTime.getTime());
        InteropTest.assertTrue((newTermTime.getTime().equals(termTime.getTime()) || newTermTime.getTime().after(termTime.getTime()) ? 1 : 0) != 0);
    }

    public void testScenario4() throws Exception {
        EndpointReferenceType endpoint = this.createResource();
        WidgetPortType port = this.locator.getWidgetPortTypePort(endpoint);
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        SetTerminationTime request = new SetTerminationTime();
        request.setRequestedTerminationTime(termTime);
        SetTerminationTimeResponse response = port.setTerminationTime(request);
        Calendar newTermTime = response.getNewTerminationTime();
        GetResourcePropertyResponse propResponse = port.getResourceProperty(WSRFConstants.TERMINATION_TIME);
        MessageElement[] any = propResponse.get_any();
        InteropTest.assertTrue((any != null ? 1 : 0) != 0);
        InteropTest.assertTrue((any.length > 0 ? 1 : 0) != 0);
        Object obj = ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$java$util$Calendar == null ? (class$java$util$Calendar = InteropTest.class$("java.util.Calendar")) : class$java$util$Calendar));
        InteropTest.assertTrue((boolean)(obj instanceof Calendar));
        InteropTest.assertEquals((Object)newTermTime.getTime(), (Object)((Calendar)obj).getTime());
    }

    public void testScenario5() throws Exception {
        EndpointReferenceType endpoint = this.createResource();
        WidgetPortType port = this.locator.getWidgetPortTypePort(endpoint);
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        SetTerminationTime request = new SetTerminationTime();
        request.setRequestedTerminationTime(termTime);
        SetTerminationTimeResponse response = port.setTerminationTime(request);
        Calendar newTermTime = response.getNewTerminationTime();
        QName[] propNames = new QName[]{WSRFConstants.TERMINATION_TIME, WSRFConstants.CURRENT_TIME};
        GetMultipleResourceProperties_Element requestProp = new GetMultipleResourceProperties_Element();
        requestProp.setResourceProperty(propNames);
        GetMultipleResourcePropertiesResponse responseProp = port.getMultipleResourceProperties(requestProp);
        MessageElement[] any = responseProp.get_any();
        InteropTest.assertTrue((any != null ? 1 : 0) != 0);
        InteropTest.assertTrue((any.length > 1 ? 1 : 0) != 0);
        Object obj1 = ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$java$util$Calendar == null ? (class$java$util$Calendar = InteropTest.class$("java.util.Calendar")) : class$java$util$Calendar));
        InteropTest.assertTrue((boolean)(obj1 instanceof Calendar));
        InteropTest.assertEquals((Object)newTermTime.getTime(), (Object)((Calendar)obj1).getTime());
        Object obj2 = ObjectDeserializer.toObject((SOAPElement)any[1], (Class)(class$java$util$Calendar == null ? (class$java$util$Calendar = InteropTest.class$("java.util.Calendar")) : class$java$util$Calendar));
        InteropTest.assertTrue((boolean)(obj2 instanceof Calendar));
    }

    public void testScenario6() throws Exception {
        EndpointReferenceType endpoint = this.createResource();
        WidgetPortType port = this.locator.getWidgetPortTypePort(endpoint);
        String dialect = "http://www.w3.org/TR/1999/REC-xpath-19991116";
        QueryExpressionType query = new QueryExpressionType();
        query.setDialect(dialect);
        query.setValue((Object)queryString);
        QueryResourceProperties_Element request = new QueryResourceProperties_Element();
        request.setQueryExpression(query);
        QueryResourcePropertiesResponse response = port.queryResourceProperties(request);
        MessageElement[] any = response.get_any();
        InteropTest.assertTrue((any != null ? 1 : 0) != 0);
        InteropTest.assertTrue((any.length > 0 ? 1 : 0) != 0);
        InteropTest.assertEquals((short)3, (short)any[0].getNodeType());
        InteropTest.assertEquals((String)"true", (String)any[0].getNodeValue());
    }

    public void testScenario7() throws Exception {
        EndpointReferenceType endpoint = this.createResource();
        WidgetPortType port = this.locator.getWidgetPortTypePort(endpoint);
        this.scenario7Case1(port);
        this.scenario7Case2(port);
        this.scenario7Case3(port);
        this.scenario7Case4(port);
    }

    private MessageElement[] getFooProperty(WidgetPortType port) throws Exception {
        GetResourcePropertyResponse propResponse = port.getResourceProperty(Widget.FOO);
        MessageElement[] any = propResponse.get_any();
        InteropTest.assertTrue((any != null ? 1 : 0) != 0);
        InteropTest.assertTrue((any.length > 0 ? 1 : 0) != 0);
        return any;
    }

    private void scenario7Case1(WidgetPortType port) throws Exception {
        GetResourcePropertyResponse propResponse = port.getResourceProperty(Widget.FOO);
        MessageElement[] any = propResponse.get_any();
        InteropTest.assertTrue((any == null ? 1 : 0) != 0);
    }

    private void scenario7Case2(WidgetPortType port) throws Exception {
        String value1 = "string1";
        InsertType insert = new InsertType();
        MessageElement[] elements = new MessageElement[]{(MessageElement)ObjectSerializer.toSOAPElement((Object)value1, (QName)Widget.FOO)};
        insert.set_any(elements);
        SetResourceProperties_Element request = new SetResourceProperties_Element();
        request.setInsert(insert);
        port.setResourceProperties(request);
        MessageElement[] any = this.getFooProperty(port);
        Object obj2 = ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = InteropTest.class$("java.lang.String")) : class$java$lang$String));
        InteropTest.assertEquals((String)value1, (String)obj2.toString().trim());
    }

    private void scenario7Case3(WidgetPortType port) throws Exception {
        String value1 = "string2";
        String value2 = "string3";
        UpdateType update = new UpdateType();
        MessageElement[] elements = new MessageElement[]{(MessageElement)ObjectSerializer.toSOAPElement((Object)value1, (QName)Widget.FOO), (MessageElement)ObjectSerializer.toSOAPElement((Object)value2, (QName)Widget.FOO)};
        update.set_any(elements);
        SetResourceProperties_Element request = new SetResourceProperties_Element();
        request.setUpdate(update);
        port.setResourceProperties(request);
        MessageElement[] any = this.getFooProperty(port);
        InteropTest.assertEquals((int)2, (int)any.length);
        Object obj1 = ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = InteropTest.class$("java.lang.String")) : class$java$lang$String));
        InteropTest.assertEquals((String)value1, (String)obj1.toString().trim());
        Object obj2 = ObjectDeserializer.toObject((SOAPElement)any[1], (Class)(class$java$lang$String == null ? (class$java$lang$String = InteropTest.class$("java.lang.String")) : class$java$lang$String));
        InteropTest.assertEquals((String)value2, (String)obj2.toString().trim());
    }

    private void scenario7Case4(WidgetPortType port) throws Exception {
        DeleteType delete = new DeleteType();
        delete.setResourceProperty(Widget.FOO);
        SetResourceProperties_Element request = new SetResourceProperties_Element();
        request.setDelete(delete);
        port.setResourceProperties(request);
        GetResourcePropertyResponse propResponse = port.getResourceProperty(Widget.FOO);
        MessageElement[] any = propResponse.get_any();
        InteropTest.assertTrue((any == null ? 1 : 0) != 0);
    }

    public void testScenario8() throws Exception {
        NotificationConsumerFactoryServiceAddressingLocator consumerFactoryLocator = new NotificationConsumerFactoryServiceAddressingLocator();
        EndpointReferenceType consumerEPR = new EndpointReferenceType();
        consumerEPR.setAddress((AttributedURI)new Address(this.getConsumerFactoryServiceAddress()));
        NotificationConsumerFactory notificationConsumerFactoryPort = consumerFactoryLocator.getNotificationConsumerFactoryPort(consumerEPR);
        EndpointReferenceType consumer = notificationConsumerFactoryPort.createNotificationConsumer(new CreateNotificationConsumer());
        EndpointReferenceType endpoint = new EndpointReferenceType(new URI(this.getNotificationServiceAddress()));
        WidgetNotificationPortType port = this.notificationLocator.getWidgetNotificationPortTypePort(endpoint);
        Subscribe request = new Subscribe();
        request.setUseNotify(Boolean.TRUE);
        request.setConsumerReference(consumer);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)WidgetNotificationService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = port.subscribe(request);
        port.generateNotification(new GenerateNotification());
        this.destroySubscription(response.getSubscriptionReference());
    }

    public void testScenario8Client() throws Exception {
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer();
        EndpointReferenceType endpoint = new EndpointReferenceType(new URI(this.getNotificationServiceAddress()));
        WidgetNotificationPortType port = this.notificationLocator.getWidgetNotificationPortTypePort(endpoint);
        Subscribe request = new Subscribe();
        request.setUseNotify(Boolean.TRUE);
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)WidgetNotificationService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = port.subscribe(request);
        port.generateNotification(new GenerateNotification());
        Thread.sleep(5000L);
        this.destroySubscription(response.getSubscriptionReference());
    }

    public void testScenario9GetCurrentMessage() throws Exception {
        EndpointReferenceType endpoint = new EndpointReferenceType(new URI(this.getNotificationServiceAddress()));
        WidgetNotificationPortType port = this.notificationLocator.getWidgetNotificationPortTypePort(endpoint);
        GetCurrentMessage request = new GetCurrentMessage();
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)WidgetNotificationService.TEST_TOPIC);
        request.setTopic(topicPath);
        GetCurrentMessageResponse response = port.getCurrentMessage(request);
        InteropTest.assertTrue((response.get_any()[0].getLocalName() == "TestNotification" && response.get_any()[0].getNamespaceURI() == "http://widgets.com" ? 1 : 0) != 0);
    }

    public void testScenario9PauseResume() throws Exception {
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer();
        EndpointReferenceType endpoint = new EndpointReferenceType(new URI(this.getNotificationServiceAddress()));
        WidgetNotificationPortType port = this.notificationLocator.getWidgetNotificationPortTypePort(endpoint);
        Subscribe request = new Subscribe();
        request.setUseNotify(Boolean.TRUE);
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)WidgetNotificationService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = port.subscribe(request);
        port.generateNotification(new GenerateNotification());
        Thread.sleep(2000L);
        SubscriptionManager subscriptionManager = this.subscriptionManagerLocator.getSubscriptionManagerPort(response.getSubscriptionReference());
        subscriptionManager.pauseSubscription(new PauseSubscription());
        port.generateNotification(new GenerateNotification());
        subscriptionManager.resumeSubscription(new ResumeSubscription());
        port.generateNotification(new GenerateNotification());
        Thread.sleep(2000L);
        subscriptionManager.destroy(new Destroy());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

