/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.ReflectionResource;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.tests.basic.TestRP;
import org.globus.wsrf.utils.XmlPersistenceHelper;

public class XmlPersistenceHelperTest
extends TestCase {
    private static final QName KEY = new QName("http://globus.org", "TestKey");
    private static final QName ELEM = new QName("http://globus.org", "TestElement");
    private static final ResourceKey KEY_1 = new SimpleResourceKey(KEY, (Object)"1");
    private static final ResourceKey KEY_2 = new SimpleResourceKey(KEY, (Object)"2");
    static /* synthetic */ Class class$org$globus$wsrf$tests$basic$TestRP;

    public void testStore() throws Exception {
        TestRP rp = new TestRP();
        rp.setValue(5);
        XmlPersistenceHelper helper = new XmlPersistenceHelper(class$org$globus$wsrf$tests$basic$TestRP == null ? (class$org$globus$wsrf$tests$basic$TestRP = XmlPersistenceHelperTest.class$("org.globus.wsrf.tests.basic.TestRP")) : class$org$globus$wsrf$tests$basic$TestRP);
        helper.store((Object)KEY_1, (Object)rp, ELEM);
        TestRP rp2 = (TestRP)helper.load((Object)KEY_1);
        XmlPersistenceHelperTest.assertEquals((int)5, (int)rp2.getValue());
    }

    public void testReflectionResource() throws Exception {
        TestRP rp = new TestRP();
        rp.setValue(5);
        XmlPersistenceHelper helper = new XmlPersistenceHelper(class$org$globus$wsrf$tests$basic$TestRP == null ? (class$org$globus$wsrf$tests$basic$TestRP = XmlPersistenceHelperTest.class$("org.globus.wsrf.tests.basic.TestRP")) : class$org$globus$wsrf$tests$basic$TestRP);
        helper.store((Object)KEY_2, (Object)rp, ELEM);
        ReflectionResource resource = new ReflectionResource();
        helper.load((Object)KEY_2, resource);
        XmlPersistenceHelperTest.assertTrue((resource.getResourceBean() != null ? 1 : 0) != 0);
        XmlPersistenceHelperTest.assertTrue((boolean)(resource.getResourceBean() instanceof TestRP));
        XmlPersistenceHelperTest.assertEquals((int)5, (int)((TestRP)resource.getResourceBean()).getValue());
        XmlPersistenceHelperTest.assertTrue((resource.getResourcePropertySet() != null ? 1 : 0) != 0);
        XmlPersistenceHelperTest.assertEquals((Object)ELEM, (Object)resource.getResourcePropertySet().getName());
    }

    public void testList() throws Exception {
        XmlPersistenceHelper helper = new XmlPersistenceHelper(class$org$globus$wsrf$tests$basic$TestRP == null ? (class$org$globus$wsrf$tests$basic$TestRP = XmlPersistenceHelperTest.class$("org.globus.wsrf.tests.basic.TestRP")) : class$org$globus$wsrf$tests$basic$TestRP);
        ResourceKey[] keys = new ResourceKey[]{KEY_1, KEY_2};
        this.listTest(helper, keys);
    }

    public void testDelete() throws Exception {
        XmlPersistenceHelper helper = new XmlPersistenceHelper(class$org$globus$wsrf$tests$basic$TestRP == null ? (class$org$globus$wsrf$tests$basic$TestRP = XmlPersistenceHelperTest.class$("org.globus.wsrf.tests.basic.TestRP")) : class$org$globus$wsrf$tests$basic$TestRP);
        this.listTest(helper, new ResourceKey[]{KEY_1, KEY_2});
        helper.remove((Object)KEY_1);
        this.listTest(helper, new ResourceKey[]{KEY_2});
    }

    public void testRemoveAll() throws Exception {
        XmlPersistenceHelper helper = new XmlPersistenceHelper(class$org$globus$wsrf$tests$basic$TestRP == null ? (class$org$globus$wsrf$tests$basic$TestRP = XmlPersistenceHelperTest.class$("org.globus.wsrf.tests.basic.TestRP")) : class$org$globus$wsrf$tests$basic$TestRP);
        this.listTest(helper, new ResourceKey[]{KEY_1, KEY_2});
        helper.removeAll();
        List list = helper.list();
        XmlPersistenceHelperTest.assertTrue((list != null ? 1 : 0) != 0);
        XmlPersistenceHelperTest.assertTrue((boolean)list.isEmpty());
    }

    private void listTest(XmlPersistenceHelper helper, ResourceKey[] keys) throws Exception {
        TestRP rp = new TestRP(10);
        for (int i = 0; i < keys.length; ++i) {
            helper.store((Object)keys[i], (Object)rp, ELEM);
        }
        List list = helper.list();
        XmlPersistenceHelperTest.assertTrue((list != null ? 1 : 0) != 0);
        XmlPersistenceHelperTest.assertEquals((int)keys.length, (int)list.size());
        HashMap listKeys = new HashMap();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            listKeys.put(iter.next(), "");
        }
        XmlPersistenceHelperTest.assertEquals((int)keys.length, (int)listKeys.size());
        for (int i = 0; i < keys.length; ++i) {
            XmlPersistenceHelperTest.assertTrue((listKeys.get(keys[i].getValue()) != null ? 1 : 0) != 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

