/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsrf.faults.BaseFaultType;

public class FaultHelperTest
extends TestCase {
    private static final QName FAULT_QNAME = new QName("http://foo", "bar");

    public void testDescription() throws Exception {
        BaseFaultType fault = new BaseFaultType();
        FaultHelper faultHelper = new FaultHelper(fault);
        faultHelper.setDescription("foo");
        FaultHelperTest.assertTrue((faultHelper.getDescription() != null ? 1 : 0) != 0);
        FaultHelperTest.assertEquals((int)1, (int)faultHelper.getDescription().length);
        FaultHelperTest.assertEquals((String)"foo", (String)faultHelper.getDescription()[0]);
        FaultHelperTest.assertEquals((String)"foo", (String)faultHelper.getDescriptionAsString());
        faultHelper.setDescription(new String[]{"bar", "foo"});
        FaultHelperTest.assertTrue((faultHelper.getDescription() != null ? 1 : 0) != 0);
        FaultHelperTest.assertEquals((int)2, (int)faultHelper.getDescription().length);
        FaultHelperTest.assertEquals((String)"bar", (String)faultHelper.getDescription()[0]);
        FaultHelperTest.assertEquals((String)"foo", (String)faultHelper.getDescription()[1]);
        FaultHelperTest.assertEquals((String)"bar / foo", (String)faultHelper.getDescriptionAsString());
        faultHelper.setDescription((String)null);
        FaultHelperTest.assertTrue((faultHelper.getDescription() == null ? 1 : 0) != 0);
        faultHelper.setDescription((String[])null);
        FaultHelperTest.assertTrue((faultHelper.getDescription() == null ? 1 : 0) != 0);
        faultHelper.addDescription("aaa");
        faultHelper.addDescription("bbb");
        FaultHelperTest.assertTrue((faultHelper.getDescription() != null ? 1 : 0) != 0);
        FaultHelperTest.assertEquals((int)2, (int)faultHelper.getDescription().length);
        FaultHelperTest.assertEquals((String)"aaa", (String)faultHelper.getDescription()[0]);
        FaultHelperTest.assertEquals((String)"bbb", (String)faultHelper.getDescription()[1]);
    }

    public void testChainingBaseFault() throws Exception {
        BaseFaultType fault = new BaseFaultType();
        FaultHelperTest.assertTrue((fault.getFaultCause() == null ? 1 : 0) != 0);
        FaultHelper faultHelper = new FaultHelper(fault);
        FaultHelperTest.assertTrue((fault.getFaultCause() != null ? 1 : 0) != 0);
        FaultHelperTest.assertEquals((int)1, (int)fault.getFaultCause().length);
        FaultHelperTest.assertEquals((Object)FaultHelper.STACK_TRACE, (Object)fault.getFaultCause()[0].getErrorCode().getDialect());
        BaseFaultType fault1 = new BaseFaultType();
        FaultHelperTest.assertTrue((fault1.getFaultCause() == null ? 1 : 0) != 0);
        faultHelper.addFaultCause((Throwable)fault1);
        FaultHelperTest.assertTrue((fault1.getFaultCause() != null ? 1 : 0) != 0);
        FaultHelperTest.assertEquals((int)1, (int)fault1.getFaultCause().length);
        FaultHelperTest.assertEquals((Object)FaultHelper.STACK_TRACE, (Object)fault1.getFaultCause()[0].getErrorCode().getDialect());
        FaultHelperTest.assertEquals((int)2, (int)fault.getFaultCause().length);
        System.out.println(ObjectSerializer.toString((Object)fault, (QName)FAULT_QNAME));
    }

    public void testChainingException() throws Exception {
        BaseFaultType fault = new BaseFaultType();
        FaultHelperTest.assertTrue((fault.getFaultCause() == null ? 1 : 0) != 0);
        FaultHelper faultHelper = new FaultHelper(fault);
        FaultHelperTest.assertTrue((fault.getFaultCause() != null ? 1 : 0) != 0);
        FaultHelperTest.assertEquals((int)1, (int)fault.getFaultCause().length);
        FaultHelperTest.assertEquals((Object)FaultHelper.STACK_TRACE, (Object)fault.getFaultCause()[0].getErrorCode().getDialect());
        Exception e = new Exception("foo bar");
        faultHelper.addFaultCause((Throwable)e);
        FaultHelperTest.assertEquals((int)2, (int)fault.getFaultCause().length);
        FaultHelperTest.assertEquals((Object)FaultHelper.STACK_TRACE, (Object)fault.getFaultCause()[0].getErrorCode().getDialect());
        FaultHelperTest.assertEquals((String)"foo bar", (String)fault.getFaultCause()[1].getDescription()[0].get_value());
        FaultHelperTest.assertEquals((int)1, (int)fault.getFaultCause()[1].getFaultCause().length);
        FaultHelperTest.assertEquals((Object)FaultHelper.STACK_TRACE, (Object)fault.getFaultCause()[1].getFaultCause()[0].getErrorCode().getDialect());
        System.out.println(ObjectSerializer.toString((Object)fault, (QName)FAULT_QNAME));
    }
}

