/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.gsi.jaas.PasswordCredential;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.impl.security.authentication.encryption.EncryptionCredentials;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.GSISecureConvAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.NoneAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.impl.security.util.FixedObjectInputStream;
import org.globus.wsrf.test.GridTestCase;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class TestSecurityDescriptor
extends GridTestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$descriptor$TestSecurityDescriptor == null ? (class$org$globus$wsrf$impl$security$descriptor$TestSecurityDescriptor = TestSecurityDescriptor.class$("org.globus.wsrf.impl.security.descriptor.TestSecurityDescriptor")) : class$org$globus$wsrf$impl$security$descriptor$TestSecurityDescriptor).getName());
    private static final String SEC_DESC_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<securityConfig xmlns=\"http://www.globus.org\"><context-lifetime value=\"1000\"/><reject-limited-proxy value=\"true\"/><gridmap value=\"fooGridMap\"/><replay-attack-filter value=\"true\"/><credential><key-file value=\"keyFile\"/><cert-file value=\"certFile\"/></credential><proxy-file value=\"proxyFile\"/><authz value=\"someNS:org.globus.someAuthz,gridmap\"/> </securityConfig>";
    private static final String SEC_DESC_2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<securityConfig xmlns=\"http://www.globus.org\"><context-lifetime value=\"1000\"/><credential><cert-file value=\"certFile\"/></credential><proxy-file value=\"proxyFile\"/><authz value=\"self\"/> </securityConfig>";
    private static final String SERVICE_DESC_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<securityConfig xmlns=\"http://www.globus.org\"><method name=\"gss:initTokenExchange\" xmlns:gss=\"http://gss.com\">  <run-as>   <service-identity/>  </run-as>  <auth-method>    <GSISecureConversation/>  </auth-method></method><method name=\"gss:continueTokenExchange\" xmlns:gss=\"http://gss.com\">  <run-as>   <system-identity/>  </run-as>  <auth-method>    <GSISecureConversation>      <protection-level>         <integrity/>      </protection-level>    </GSISecureConversation>    <GSISecureMessage>       <protection-level>          <integrity/>      </protection-level>      </GSISecureMessage>  </auth-method></method><method name=\"wsse:findData\" xmlns:wsse=\"http://wsse.com\">  <auth-method>    <none/>  </auth-method></method><run-as> <caller-identity/></run-as><auth-method>    <GSISecureConversation>      <protection-level>         <privacy/>      </protection-level>    </GSISecureConversation></auth-method><method name=\"wsse:dummyMeth\" xmlns:wsse=\"http://wsse.com\"> <auth-method>   <GSISecureMessage>      <protection-level>        <integrity/>      </protection-level>    </GSISecureMessage>   <GSISecureConversation>        <protection-level>         <privacy/>       </protection-level>     </GSISecureConversation> </auth-method></method> <method name=\"wsse:dummyMeth1\" xmlns:wsse=\"http://wsse.com\"> <auth-method>   <GSISecureMessage/>   <GSISecureConversation>       <protection-level>          <privacy/>      </protection-level>    </GSISecureConversation> </auth-method></method><method name=\"dummyMeth2\"> <auth-method>   <GSISecureMessage/>   <GSISecureConversation/>  </auth-method></method> <reject-limited-proxy value=\"false\"/> <context-lifetime value=\"100\"/></securityConfig>";
    private static final String SERVICE_DESC_2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<securityConfig xmlns=\"http://www.globus.org\"><method name=\"gss:continueTokenExchange\" xmlns:gss=\"http://gss.com\">  <run-as>   <service-identity/>  </run-as>  <auth-method>    <GSISecureConversation>      <protection-level>         <integrity/>      </protection-level>    </GSISecureConversation>    <GSISecureMessage>       <protection-level>          <integrity/>      </protection-level>      </GSISecureMessage>  </auth-method></method><method name=\"gss:tempMethod\" xmlns:gss=\"http://gss.com\">  <auth-method>    <GSITransport>      <protection-level>         <integrity/>      </protection-level>    </GSITransport>  </auth-method></method>  <auth-method>    <GSITransport>      <protection-level>         <privacy/>      </protection-level>    </GSITransport>  </auth-method></securityConfig>";
    private static final String CONTAINER_DESC_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<securityConfig xmlns=\"http://www.globus.org\"><replay-timer-interval value=\"1000\"/><context-timer-interval value=\"12000\"/></securityConfig>";
    private static final String CLIENT_DESC_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<securityConfig xmlns=\"http://www.globus.org\"><authz value=\"host\"/><GSISecureMessage><privacy/><peer-credentials value=\"dummyPeer\"/></GSISecureMessage><credential><cert-file value=\"certFile\"/><key-file value=\"keyFile\"/></credential><proxy-file value=\"proxyFile\"/></securityConfig>";
    private static final String CLIENT_DESC_2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<securityConfig xmlns=\"http://www.globus.org\"><GSISecureMessage><privacy/><peer-credentials value=\"dummyPeer\"/></GSISecureMessage><GSISecureConversation><integrity/><delegation value=\"full\"/><anonymous/></GSISecureConversation></securityConfig>";
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$descriptor$TestSecurityDescriptor;

    public TestSecurityDescriptor(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$descriptor$TestSecurityDescriptor == null ? (class$org$globus$wsrf$impl$security$descriptor$TestSecurityDescriptor = TestSecurityDescriptor.class$("org.globus.wsrf.impl.security.descriptor.TestSecurityDescriptor")) : class$org$globus$wsrf$impl$security$descriptor$TestSecurityDescriptor);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestSecurityDescriptor.suite());
    }

    protected Element getDescriptor(String desc) throws Exception {
        InputSource is = new InputSource(new ByteArrayInputStream(desc.getBytes()));
        Document doc = XmlUtils.newDocument((InputSource)is);
        return doc.getDocumentElement();
    }

    public void testGSITransport() throws Exception {
        ServiceSecurityDescriptor desc = new ServiceSecurityDescriptor();
        Element elem = this.getDescriptor(SERVICE_DESC_2);
        desc.parse(elem);
        QName name = new QName("http://gss.com", "tempMethod");
        Vector<GSITransportAuthMethod> methods = new Vector<GSITransportAuthMethod>();
        methods.add(GSITransportAuthMethod.INTEGRITY);
        this.compare(methods, desc.getAuthMethods(name));
        methods.clear();
        methods.add(GSITransportAuthMethod.PRIVACY);
        this.compare(methods, desc.getDefaultAuthMethods());
    }

    public void testSecurityDesc() throws Exception {
        TestSecurityDescriptor.assertTrue((TEST_CONTAINER != null ? 1 : 0) != 0);
        ServiceSecurityDescriptor desc = new ServiceSecurityDescriptor();
        Element elem = this.getDescriptor(SEC_DESC_1);
        desc.parse(elem);
        this.verifyDescriptor1(desc);
        ContainerSecurityDescriptor desc1 = new ContainerSecurityDescriptor();
        elem = this.getDescriptor(SEC_DESC_1);
        desc1.parse(elem);
        desc = new ServiceSecurityDescriptor();
        elem = this.getDescriptor(SEC_DESC_2);
        boolean exp = false;
        try {
            desc.parse(elem);
            TestSecurityDescriptor.fail((String)"Did not throw exception as expected");
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("Credential") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        TestSecurityDescriptor.assertTrue((boolean)exp);
    }

    private void verifyDescriptor1(ServiceSecurityDescriptor desc) throws Exception {
        TestSecurityDescriptor.assertTrue((boolean)desc.getContextLifetime().equals(new Integer(1000)));
        TestSecurityDescriptor.assertTrue((boolean)desc.getRejectLimitedProxyState().equals("true"));
        TestSecurityDescriptor.assertTrue((boolean)desc.getGridMapFile().equals("fooGridMap"));
        TestSecurityDescriptor.assertTrue((boolean)desc.getReplayAttackFilter().equals("true"));
        TestSecurityDescriptor.assertTrue((boolean)desc.getKeyFilename().equals("keyFile"));
        TestSecurityDescriptor.assertTrue((boolean)desc.getCertFilename().equals("certFile"));
        TestSecurityDescriptor.assertTrue((boolean)desc.getProxyFilename().equals("proxyFile"));
        TestSecurityDescriptor.assertTrue((boolean)desc.getAuthz().equals("someNS:org.globus.someAuthz,gridmap"));
    }

    public void testMethodIdentity() throws Exception {
        ServiceSecurityDescriptor desc = new ServiceSecurityDescriptor();
        Element elem = this.getDescriptor(SERVICE_DESC_1);
        desc.parse(elem);
        this.verifyDescriptor2(desc);
        ServiceSecurityDescriptor desc1 = new ServiceSecurityDescriptor();
        elem = this.getDescriptor(SERVICE_DESC_2);
        desc1.parse(elem);
        QName name = new QName("http://gss.com", "continueTokenExchange");
        TestSecurityDescriptor.assertEquals((int)-1, (int)desc1.getDefaultRunAsType());
        TestSecurityDescriptor.assertEquals((int)3, (int)desc1.getRunAsType(name));
    }

    private void verifyDescriptor2(ServiceSecurityDescriptor desc) {
        QName name = null;
        TestSecurityDescriptor.assertEquals((int)1, (int)desc.getDefaultRunAsType());
        name = new QName("foo", "baar");
        TestSecurityDescriptor.assertEquals((int)-1, (int)desc.getRunAsType(name));
        name = new QName("http://gss.com", "initTokenExchange");
        TestSecurityDescriptor.assertEquals((int)3, (int)desc.getRunAsType(name));
        name = new QName("http://gss.com", "continueTokenExchange");
        TestSecurityDescriptor.assertEquals((int)2, (int)desc.getRunAsType(name));
    }

    public void testDefaultAuthMethods() throws Exception {
        Element elem = null;
        QName name = null;
        Vector<Object> methods = new Vector<Object>();
        ServiceSecurityDescriptor desc = new ServiceSecurityDescriptor();
        elem = this.getDescriptor(SERVICE_DESC_1);
        desc.parse(elem);
        methods.add(GSISecureConvAuthMethod.PRIVACY);
        this.compare(methods, desc.getDefaultAuthMethods());
        name = new QName("foo", "baar");
        List getList = desc.getAuthMethods(name);
        TestSecurityDescriptor.assertTrue((getList == null ? 1 : 0) != 0);
        methods.clear();
        methods.add(GSISecureConvAuthMethod.BOTH);
        name = new QName("http://gss.com", "initTokenExchange");
        this.compare(methods, desc.getAuthMethods(name));
        methods.clear();
        methods.add(GSISecureConvAuthMethod.INTEGRITY);
        methods.add(GSISecureMsgAuthMethod.INTEGRITY);
        name = new QName("http://gss.com", "continueTokenExchange");
        this.compare(methods, desc.getAuthMethods(name));
        methods.clear();
        methods.add(NoneAuthMethod.getInstance());
        name = new QName("http://wsse.com", "findData");
        this.compare(methods, desc.getAuthMethods(name));
        methods.clear();
        methods.add(GSISecureMsgAuthMethod.INTEGRITY);
        methods.add(GSISecureConvAuthMethod.PRIVACY);
        name = new QName("http://wsse.com", "dummyMeth");
        this.compare(methods, desc.getAuthMethods(name));
        methods.clear();
        methods.add(GSISecureMsgAuthMethod.BOTH);
        methods.add(GSISecureConvAuthMethod.PRIVACY);
        name = new QName("http://wsse.com", "dummyMeth1");
        this.compare(methods, desc.getAuthMethods(name));
        methods.clear();
        methods.add(GSISecureMsgAuthMethod.BOTH);
        methods.add(GSISecureConvAuthMethod.BOTH);
        name = new QName("http://wsse.com", "dummyMeth2");
        this.compare(methods, desc.getAuthMethods(name));
        name = new QName("http://foo", "dummyMeth2");
        this.compare(methods, desc.getAuthMethods(name));
    }

    public void testContainerDesc() throws Exception {
        ContainerSecurityDescriptor desc = new ContainerSecurityDescriptor();
        Element elem = this.getDescriptor(CONTAINER_DESC_1);
        desc.parse(elem);
        this.verifyContainerDesc(desc);
    }

    private void verifyContainerDesc(ContainerSecurityDescriptor desc) {
        TestSecurityDescriptor.assertTrue((desc.getRejectLimitedProxyState() == null ? 1 : 0) != 0);
        TestSecurityDescriptor.assertTrue((desc.getContextLifetime() == null ? 1 : 0) != 0);
        TestSecurityDescriptor.assertTrue((boolean)desc.getReplayTimerInterval().equals("1000"));
        TestSecurityDescriptor.assertTrue((boolean)desc.getContextTimerInterval().equals("12000"));
    }

    public void testClientDesc() throws Exception {
        ClientSecurityDescriptor desc1 = new ClientSecurityDescriptor();
        Element elem = this.getDescriptor(CLIENT_DESC_1);
        desc1.parse(elem);
        this.verifyClientDesc1(desc1);
        ClientSecurityDescriptor desc2 = new ClientSecurityDescriptor();
        elem = this.getDescriptor(CLIENT_DESC_2);
        desc2.parse(elem);
        this.verifyClientDesc2(desc2);
    }

    private void verifyClientDesc1(ClientSecurityDescriptor desc) throws Exception {
        TestSecurityDescriptor.assertTrue((boolean)(desc.getAuthz() instanceof HostAuthorization));
        TestSecurityDescriptor.assertTrue((boolean)GSIConstants.ENCRYPTION.equals(desc.getGSISecureMsg()));
        TestSecurityDescriptor.assertTrue((desc.getGSISecureConv() == null ? 1 : 0) != 0);
        TestSecurityDescriptor.assertTrue((desc.getAnonymous() == null ? 1 : 0) != 0);
        TestSecurityDescriptor.assertTrue((boolean)"dummyPeer".equals(desc.getPeerCredentials()));
        TestSecurityDescriptor.assertTrue((boolean)"proxyFile".equals(desc.getProxyFilename()));
        TestSecurityDescriptor.assertTrue((boolean)"certFile".equals(desc.getCertFilename()));
        TestSecurityDescriptor.assertTrue((boolean)"keyFile".equals(desc.getKeyFilename()));
    }

    private void verifyClientDesc2(ClientSecurityDescriptor desc1) throws Exception {
        TestSecurityDescriptor.assertTrue((desc1.getAuthz() == null ? 1 : 0) != 0);
        TestSecurityDescriptor.assertTrue((boolean)GSIConstants.ENCRYPTION.equals(desc1.getGSISecureMsg()));
        TestSecurityDescriptor.assertTrue((boolean)GSIConstants.SIGNATURE.equals(desc1.getGSISecureConv()));
        TestSecurityDescriptor.assertTrue((boolean)Boolean.TRUE.equals(desc1.getAnonymous()));
        TestSecurityDescriptor.assertTrue((boolean)"gsifull".equals(desc1.getDelegation()));
        TestSecurityDescriptor.assertTrue((boolean)"dummyPeer".equals(desc1.getPeerCredentials()));
    }

    private void compare(List expected, List current) {
        TestSecurityDescriptor.assertEquals((int)expected.size(), (int)current.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestSecurityDescriptor.assertEquals(expected.get(i), current.get(i));
        }
    }

    private Subject getSubject() throws Exception {
        GlobusCredential credential = GlobusCredential.getDefaultCredential();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new GlobusPrincipal("random one"));
        subject.getPublicCredentials().add(credential.getCertificateChain());
        subject.getPublicCredentials().add(credential.getIdentityCertificate());
        subject.getPublicCredentials().add(new EncryptionCredentials(credential.getCertificateChain()));
        subject.getPrivateCredentials().add(new GlobusGSSCredentialImpl(credential, 1));
        subject.getPrivateCredentials().add(new PasswordCredential("newPass"));
        return subject;
    }

    private void verifySubject(Subject subject) throws Exception {
        TestSecurityDescriptor.assertTrue((subject != null ? 1 : 0) != 0);
        Set<Object> publicCreds = subject.getPublicCredentials();
        TestSecurityDescriptor.assertTrue((!publicCreds.isEmpty() ? 1 : 0) != 0);
        TestSecurityDescriptor.assertTrue((publicCreds.size() == 3 ? 1 : 0) != 0);
        Iterator<Object> iter = publicCreds.iterator();
        Object obj = iter.next();
        TestSecurityDescriptor.assertTrue((boolean)(obj instanceof X509Certificate[]));
        obj = iter.next();
        TestSecurityDescriptor.assertTrue((boolean)(obj instanceof X509Certificate));
        obj = iter.next();
        TestSecurityDescriptor.assertTrue((boolean)(obj instanceof EncryptionCredentials));
        TestSecurityDescriptor.assertTrue((((EncryptionCredentials)obj).getCertificates() != null ? 1 : 0) != 0);
        Set<Object> privateCreds = subject.getPrivateCredentials();
        TestSecurityDescriptor.assertTrue((!privateCreds.isEmpty() ? 1 : 0) != 0);
        TestSecurityDescriptor.assertTrue((privateCreds.size() == 2 ? 1 : 0) != 0);
        iter = privateCreds.iterator();
        obj = iter.next();
        TestSecurityDescriptor.assertTrue((boolean)(obj instanceof GlobusGSSCredentialImpl));
        obj = iter.next();
        TestSecurityDescriptor.assertTrue((boolean)(obj instanceof PasswordCredential));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistence() throws Exception {
        ServiceSecurityDescriptor desc1 = new ServiceSecurityDescriptor();
        Element elem = this.getDescriptor(SEC_DESC_1);
        desc1.parse(elem);
        ServiceSecurityDescriptor desc2 = new ServiceSecurityDescriptor();
        elem = this.getDescriptor(SERVICE_DESC_1);
        desc2.parse(elem);
        ContainerSecurityDescriptor contDesc = new ContainerSecurityDescriptor();
        elem = this.getDescriptor(CONTAINER_DESC_1);
        contDesc.parse(elem);
        GridMap gridMap = new GridMap();
        gridMap.map("hello", "world");
        gridMap.map("some", "map");
        Subject subject = this.getSubject();
        ClientSecurityDescriptor clientDesc1 = new ClientSecurityDescriptor();
        elem = this.getDescriptor(CLIENT_DESC_1);
        clientDesc1.parse(elem);
        ClientSecurityDescriptor clientDesc2 = new ClientSecurityDescriptor();
        elem = this.getDescriptor(CLIENT_DESC_2);
        clientDesc2.parse(elem);
        ServiceSecurityDescriptor serviceDesc = new ServiceSecurityDescriptor();
        serviceDesc.setSubject(subject);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        File tmpFile = new File("security-desc-test.tmp");
        try {
            fos = new FileOutputStream(tmpFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(desc1);
            oos.writeObject(desc2);
            oos.writeObject(contDesc);
            oos.writeObject(gridMap);
            AuthUtil.writeSubject((Subject)subject, (ObjectOutputStream)oos);
            oos.writeObject(clientDesc1);
            oos.writeObject(clientDesc2);
            oos.writeObject(serviceDesc);
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fos != null) {
                fos.close();
            }
            if (oos != null) {
                oos.close();
            }
        }
        catch (Exception e) {}
        FileInputStream fis = null;
        FixedObjectInputStream ois = null;
        ServiceSecurityDescriptor readInDesc1 = null;
        ServiceSecurityDescriptor readInDesc2 = null;
        ContainerSecurityDescriptor readInCont = null;
        GridMap readInGridMap = null;
        Subject readInSubject = null;
        ClientSecurityDescriptor readClient1 = null;
        ClientSecurityDescriptor readClient2 = null;
        ServiceSecurityDescriptor readInDesc3 = null;
        try {
            fis = new FileInputStream(tmpFile);
            ois = new FixedObjectInputStream((InputStream)fis);
            readInDesc1 = (ServiceSecurityDescriptor)ois.readObject();
            readInDesc2 = (ServiceSecurityDescriptor)ois.readObject();
            readInCont = (ContainerSecurityDescriptor)ois.readObject();
            readInGridMap = (GridMap)ois.readObject();
            readInSubject = AuthUtil.readSubject((FixedObjectInputStream)ois);
            readClient1 = (ClientSecurityDescriptor)ois.readObject();
            readClient2 = (ClientSecurityDescriptor)ois.readObject();
            readInDesc3 = (ServiceSecurityDescriptor)ois.readObject();
            Object var24_26 = null;
        }
        catch (Throwable throwable) {
            Object var24_27 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (ois != null) {
                    ois.close();
                }
                tmpFile.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
            if (ois != null) {
                ois.close();
            }
            tmpFile.delete();
        }
        catch (Exception e) {}
        this.verifyDescriptor1(readInDesc1);
        this.verifyDescriptor2(readInDesc2);
        this.verifyContainerDesc(readInCont);
        this.verifyClientDesc1(readClient1);
        this.verifySubject(readInSubject);
        this.verifyClientDesc2(readClient2);
        Subject retr = readInDesc3.getSubject();
        this.verifySubject(retr);
        tmpFile.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

