/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.security.Principal;
import java.util.List;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.Resource;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecondTestResource;
import org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.TestResource;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.test.GridTestCase;

public class TestSecurityConfig
extends GridTestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$descriptor$TestSecurityConfig == null ? (class$org$globus$wsrf$impl$security$descriptor$TestSecurityConfig = TestSecurityConfig.class$("org.globus.wsrf.impl.security.descriptor.TestSecurityConfig")) : class$org$globus$wsrf$impl$security$descriptor$TestSecurityConfig).getName());
    private String USER1 = "/CN=foo";
    private String service1Path = "TestService1";
    private String service2Path = "TestService2";
    private Subject service1Subject = null;
    private Subject service2Subject = null;
    private Subject containerSubject = null;
    private GridMap service1GridMap = null;
    private GridMap service2GridMap = null;
    private GridMap containerGridMap = null;
    private String containerReplayWin = "10000";
    private String replayInterval = "randomVal1";
    private String contextInterval = "ramdomVal2";
    private String service2ReplayWin = "20000";
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$descriptor$TestSecurityConfig;

    public TestSecurityConfig(String name) throws Exception {
        super(name);
        JNDIUtils.initJNDI();
        logger.debug((Object)"Done");
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$descriptor$TestSecurityConfig == null ? (class$org$globus$wsrf$impl$security$descriptor$TestSecurityConfig = TestSecurityConfig.class$("org.globus.wsrf.impl.security.descriptor.TestSecurityConfig")) : class$org$globus$wsrf$impl$security$descriptor$TestSecurityConfig);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestSecurityConfig.suite());
    }

    public void testServiceSecurityConfig() throws Exception {
        TestSecurityConfig.assertTrue((TEST_CONTAINER != null ? 1 : 0) != 0);
        this.service1Test();
        logger.debug((Object)"service 1 Done");
        ContainerSecurityDescriptor desc = ContainerSecurityConfig.getConfig().getSecurityDescriptor();
        TestSecurityConfig.assertTrue((desc.getReplayTimerInterval() == null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((desc.getContextTimerInterval() == null ? 1 : 0) != 0);
        this.containerTest();
        logger.debug((Object)"container Done");
        ContainerSecurityDescriptor desc1 = ContainerSecurityConfig.getConfig().getSecurityDescriptor();
        TestSecurityConfig.assertTrue((boolean)this.replayInterval.equals(desc1.getReplayTimerInterval()));
        TestSecurityConfig.assertTrue((boolean)this.contextInterval.equals(desc1.getContextTimerInterval()));
        this.service2Test();
        logger.debug((Object)"service 2 Done");
        this.serviceHelperTest();
        logger.debug((Object)"service helper Done");
        this.clientDescriptorTest();
    }

    private void clientDescriptorTest() throws Exception {
        ClientSecurityDescriptor desc = ClientSecurityConfig.initialize((String)"org/globus/wsrf/impl/security/descriptor/client-security-desc.xml");
        TestSecurityConfig.assertTrue((boolean)GSIConstants.ENCRYPTION.equals(desc.getGSISecureMsg()));
        TestSecurityConfig.assertTrue((boolean)GSIConstants.SIGNATURE.equals(desc.getGSISecureConv()));
        TestSecurityConfig.assertTrue((boolean)Boolean.TRUE.equals(desc.getAnonymous()));
        TestSecurityConfig.assertTrue((boolean)"gsifull".equals(desc.getDelegation()));
        TestSecurityConfig.assertTrue((boolean)(desc.getAuthz() instanceof HostAuthorization));
    }

    private void service1Test() throws Exception {
        logger.debug((Object)"service one test");
        ServiceSecurityConfig.initialize((String)this.service1Path, null);
        logger.debug((Object)"service1Path initialized");
        TestSecurityConfig.assertTrue((ServiceSecurityConfig.getSubject((String)this.service1Path) == null ? 1 : 0) != 0);
        ServiceSecurityConfig.refresh((String)this.service1Path);
        logger.debug((Object)"refresh done");
        this.service1Subject = new Subject();
        this.service1Subject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        ServiceSecurityConfig.setSubject((Subject)this.service1Subject, (String)this.service1Path);
        ServiceSecurityConfig.refresh((String)this.service1Path);
        Subject subject = ServiceSecurityConfig.getSubject((String)this.service1Path);
        TestSecurityConfig.assertTrue((subject != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)subject.equals(this.service1Subject));
        this.service1GridMap = new GridMap();
        this.service1GridMap.map(this.USER1, "nobody");
        ServiceSecurityConfig.setGridMap((GridMap)this.service1GridMap, (String)this.service1Path);
        GridMap gridMap = ServiceSecurityConfig.getGridMap((String)this.service1Path);
        TestSecurityConfig.assertTrue((gridMap != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)gridMap.equals(this.service1GridMap));
        ServiceSecurityDescriptor desc = new ServiceSecurityDescriptor();
        desc.setRunAsType(1);
        Vector<QName> methods = new Vector<QName>();
        QName qName1 = new QName("http://www.globus.org", "method1");
        methods.add(qName1);
        QName qName2 = new QName("http://www.globus.org", "method2");
        methods.add(qName2);
        desc.setAuthMethods(methods);
        desc.setRejectLimitedProxy("false");
        desc.setSubject(subject);
        desc.setGridMap(gridMap);
        ServiceSecurityConfig.setSecurityDescriptor((ServiceSecurityDescriptor)desc, (String)this.service1Path);
        subject = ServiceSecurityConfig.getSubject((String)this.service1Path);
        TestSecurityConfig.assertTrue((subject != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)subject.equals(this.service1Subject));
        gridMap = ServiceSecurityConfig.getGridMap((String)this.service1Path);
        TestSecurityConfig.assertTrue((gridMap != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)gridMap.equals(this.service1GridMap));
        ServiceSecurityDescriptor secDesc = ServiceSecurityConfig.getSecurityDescriptor((String)this.service1Path);
        TestSecurityConfig.assertTrue((secDesc != null ? 1 : 0) != 0);
        this.compare(desc.getAuthMethods(qName1), secDesc.getAuthMethods(qName1));
        this.compare(desc.getAuthMethods(qName2), secDesc.getAuthMethods(qName2));
        this.compare(desc.getDefaultAuthMethods(), secDesc.getDefaultAuthMethods());
        TestSecurityConfig.assertTrue((desc.getRejectLimitedProxyState() != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)desc.getRejectLimitedProxyState().equals("false"));
    }

    private void containerTest() throws Exception {
        logger.debug((Object)"container test");
        ContainerSecurityConfig config = ContainerSecurityConfig.getConfig();
        Subject contSubject = config.getSubject();
        TestSecurityConfig.assertTrue((contSubject != null ? 1 : 0) != 0);
        logger.debug((Object)contSubject);
        this.containerSubject = new Subject();
        this.containerSubject.getPrincipals().add((Principal)new GlobusPrincipal("containerUser"));
        ContainerSecurityConfig.getConfig().setSubject(this.containerSubject);
        this.containerGridMap = new GridMap();
        this.containerGridMap.map(this.USER1, "containerLogin");
        ContainerSecurityConfig.getConfig().setGridMap(this.containerGridMap);
        Subject retSubject = ContainerSecurityConfig.getConfig().getSubject();
        TestSecurityConfig.assertTrue((retSubject != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)this.containerSubject.equals(retSubject));
        logger.debug((Object)("Container " + this.containerSubject));
        GridMap retGridMap = ContainerSecurityConfig.getConfig().getGridMap();
        TestSecurityConfig.assertTrue((boolean)this.containerGridMap.equals(retGridMap));
        ContainerSecurityDescriptor desc = new ContainerSecurityDescriptor();
        desc.setRejectLimitedProxy("true");
        desc.setSubject(this.containerSubject);
        desc.setGridMap(this.containerGridMap);
        desc.setReplayAttackWindow(this.containerReplayWin);
        desc.setReplayTimerInterval(this.replayInterval);
        desc.setContextTimerInterval(this.contextInterval);
        ContainerSecurityConfig.getConfig().setSecurityDescriptor(desc);
        ContainerSecurityDescriptor retDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor();
        TestSecurityConfig.assertTrue((retDesc != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((retDesc.getRejectLimitedProxyState() != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)retDesc.getRejectLimitedProxyState().equals("true"));
        retSubject = ContainerSecurityConfig.getConfig().getSubject();
        TestSecurityConfig.assertTrue((retSubject != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)this.containerSubject.equals(retSubject));
        logger.debug((Object)("Container " + this.containerSubject));
    }

    private void service2Test() throws Exception {
        logger.debug((Object)"service two test");
        ServiceSecurityConfig.initialize((String)this.service2Path, null);
        TestSecurityConfig.assertTrue((ServiceSecurityConfig.getSubject((String)this.service2Path) == null ? 1 : 0) != 0);
        this.service2Subject = new Subject();
        this.service2Subject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        ServiceSecurityConfig.setSubject((Subject)this.service2Subject, (String)this.service2Path);
        this.service2GridMap = new GridMap();
        this.service2GridMap.map(this.USER1, "dummy");
        ServiceSecurityConfig.setGridMap((GridMap)this.service2GridMap, (String)this.service2Path);
        Subject subject = ServiceSecurityConfig.getSubject((String)this.service2Path);
        TestSecurityConfig.assertTrue((subject != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)subject.equals(this.service2Subject));
        GridMap gridMap = ServiceSecurityConfig.getGridMap((String)this.service2Path);
        TestSecurityConfig.assertTrue((gridMap != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)gridMap.equals(this.service2GridMap));
        ServiceSecurityDescriptor desc = new ServiceSecurityDescriptor();
        desc.setReplayAttackWindow(this.service2ReplayWin);
        ServiceSecurityConfig.setSecurityDescriptor((ServiceSecurityDescriptor)desc, (String)this.service2Path);
    }

    private void serviceHelperTest() throws Exception {
        logger.debug((Object)"service helper test");
        ServiceSecurityConfig.setSubject(null, (String)this.service2Path);
        ServiceSecurityConfig.setGridMap(null, (String)this.service2Path);
        ContainerSecurityDescriptor retDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor();
        TestSecurityConfig.assertTrue((retDesc != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((retDesc.getRejectLimitedProxyState() != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)retDesc.getRejectLimitedProxyState().equals("true"));
        Subject systemSub = SecurityManager.getManager().getSystemSubject();
        TestSecurityConfig.assertTrue((systemSub != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((!systemSub.equals(this.containerSubject) ? 1 : 0) != 0);
        this.containerSubject = SecurityManager.getManager().getSystemSubject();
        retDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor();
        TestSecurityConfig.assertTrue((retDesc != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((retDesc.getRejectLimitedProxyState() != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)retDesc.getRejectLimitedProxyState().equals("true"));
        Subject serviceSub = SecurityManager.getManager().getServiceSubject(this.service1Path);
        TestSecurityConfig.assertTrue((serviceSub != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)serviceSub.equals(this.service1Subject));
        Subject service2Sub = SecurityManager.getManager().getServiceSubject(this.service2Path);
        TestSecurityConfig.assertTrue((boolean)service2Sub.equals(this.containerSubject));
        Subject sub = SecurityManager.getManager().getSubject(this.service2Path, null);
        TestSecurityConfig.assertTrue((sub != null ? 1 : 0) != 0);
        TestSecurityConfig.assertTrue((boolean)sub.equals(this.containerSubject));
        TestSecurityConfig.assertTrue((boolean)Boolean.FALSE.equals(SecurityPropertiesHelper.getRejectLimitedProxyState((String)this.service1Path, null)));
        TestSecurityConfig.assertTrue((boolean)Boolean.TRUE.equals(SecurityPropertiesHelper.getRejectLimitedProxyState((String)this.service2Path, null)));
        TestSecurityConfig.assertTrue((boolean)this.containerReplayWin.equals(SecurityPropertiesHelper.getReplayAttackWindow((String)this.service1Path, null)));
        TestSecurityConfig.assertTrue((boolean)this.service2ReplayWin.equals(SecurityPropertiesHelper.getReplayAttackWindow((String)this.service2Path, null)));
        TestSecurityConfig.assertTrue((boolean)SecurityPropertiesHelper.getGridMap((String)this.service1Path, null).equals(this.service1GridMap));
        TestSecurityConfig.assertTrue((boolean)SecurityPropertiesHelper.getGridMap((String)this.service2Path, null).equals(this.containerGridMap));
        TestResource res1 = new TestResource("true");
        TestSecurityConfig.assertTrue((boolean)Boolean.TRUE.equals(SecurityPropertiesHelper.getRejectLimitedProxyState((String)this.service1Path, (Resource)res1)));
        String filename = "org/globus/wsrf/impl/security/descriptor/test-security-true.xml";
        SecondTestResource res2 = new SecondTestResource(filename);
        TestSecurityConfig.assertTrue((boolean)Boolean.TRUE.equals(SecurityPropertiesHelper.getRejectLimitedProxyState((String)this.service1Path, (Resource)res2)));
        filename = "org/globus/wsrf/impl/security/descriptor/test-security-false.xml";
        SecondTestResource res3 = new SecondTestResource(filename);
        TestSecurityConfig.assertTrue((boolean)Boolean.FALSE.equals(SecurityPropertiesHelper.getRejectLimitedProxyState((String)this.service2Path, (Resource)res3)));
    }

    private void compare(List expected, List current) {
        if (expected == null) {
            TestSecurityConfig.assertTrue((current == null ? 1 : 0) != 0);
            return;
        }
        TestSecurityConfig.assertTrue((current != null ? 1 : 0) != 0);
        TestSecurityConfig.assertEquals((int)expected.size(), (int)current.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestSecurityConfig.assertEquals(expected.get(i), current.get(i));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

