/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.security.Principal;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.jndi.JNDIUtils;

public class TestSelfAuthorization
extends TestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization = TestSelfAuthorization.class$("org.globus.wsrf.impl.security.authorization.TestSelfAuthorization")) : class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization).getName());
    private Subject anonSubject = new Subject();
    private String USER1 = "/CN=foo";
    private String USER2 = "/CN=bar";
    private String USER3 = "/CN=tmp";
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization;

    public TestSelfAuthorization(String name) throws Exception {
        super(name);
        Context initialContext = JNDIUtils.initJNDI();
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization = TestSelfAuthorization.class$("org.globus.wsrf.impl.security.authorization.TestSelfAuthorization")) : class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestSelfAuthorization.suite());
    }

    public void testAnonymous() throws Exception {
        SelfAuthorization pdp = SelfAuthorization.getInstance();
        String servicePath = "tempService1";
        Subject serviceSubject = new Subject();
        serviceSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        this.storeServiceSubject(servicePath, serviceSubject);
        boolean exp = false;
        try {
            pdp.initialize(null, null, servicePath);
            pdp.isPermitted(this.anonSubject, (MessageContext)new org.apache.axis.MessageContext(null), null);
            TestSelfAuthorization.fail((String)"Failed to throw exception");
        }
        catch (AuthorizationException e) {
            if (e.getMessage().indexOf("anonymous") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        TestSelfAuthorization.assertTrue((boolean)exp);
    }

    public void testFail() throws Exception {
        SelfAuthorization pdp = SelfAuthorization.getInstance();
        String servicePath = "tempService2";
        Subject serviceSubject = new Subject();
        serviceSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        this.storeServiceSubject(servicePath, serviceSubject);
        Subject callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER2));
        pdp.initialize(null, null, servicePath);
        TestSelfAuthorization.assertFalse((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), null));
    }

    public void testSuccess() throws Exception {
        SelfAuthorization pdp = SelfAuthorization.getInstance();
        String servicePath = "tempService2";
        Subject serviceSubject = new Subject();
        serviceSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER3));
        this.storeServiceSubject(servicePath, serviceSubject);
        Subject callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER2));
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER3));
        pdp.initialize(null, null, servicePath);
        TestSelfAuthorization.assertTrue((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), null));
    }

    private void storeServiceSubject(String servicePath, Subject subject) throws Exception {
        ServiceSecurityConfig.initialize((String)servicePath, null);
        ServiceSecurityConfig.setSubject((Subject)subject, (String)servicePath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

