/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.io.File;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.wsrf.impl.security.authorization.LocalConfigPDP;
import org.globus.wsrf.impl.security.authorization.ResourcePDPConfig;
import org.globus.wsrf.security.authorization.PDPConfig;

public class TestLocalConfig
extends TestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$TestLocalConfig == null ? (class$org$globus$wsrf$impl$security$authorization$TestLocalConfig = TestLocalConfig.class$("org.globus.wsrf.impl.security.authorization.TestLocalConfig")) : class$org$globus$wsrf$impl$security$authorization$TestLocalConfig).getName());
    String PDP_NAME = "testConfig";
    private Subject anonSubject = new Subject();
    private QName readQName = new QName("http://org.test", "read");
    private QName writeQName = new QName("http://org.test", "write");
    private QName execQName = new QName("http://org.test", "exec");
    private ResourcePDPConfig resourceConfig = null;
    private String USER1 = "/CN=foo";
    private String USER2 = "/CN=bar";
    private String USER3 = "/CN=tmp";
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$TestLocalConfig;

    public TestLocalConfig(String name) throws Exception {
        super(name);
        String globusLocation = System.getProperty("GLOBUS_LOCATION");
        String testConf = globusLocation + File.separator + "etc" + File.separator + "globus_wsrf_test_unit" + File.separator + "local-config-authz-test.conf";
        this.resourceConfig = new ResourcePDPConfig("test");
        this.resourceConfig.setProperty(this.PDP_NAME, "authzConfigFile", (Object)testConf);
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authorization$TestLocalConfig == null ? (class$org$globus$wsrf$impl$security$authorization$TestLocalConfig = TestLocalConfig.class$("org.globus.wsrf.impl.security.authorization.TestLocalConfig")) : class$org$globus$wsrf$impl$security$authorization$TestLocalConfig);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestLocalConfig.suite());
    }

    public void testAnonymous() throws Exception {
        LocalConfigPDP pdp = new LocalConfigPDP();
        pdp.initialize((PDPConfig)this.resourceConfig, this.PDP_NAME, "dummyService");
        TestLocalConfig.assertFalse((boolean)pdp.isPermitted(this.anonSubject, (MessageContext)new org.apache.axis.MessageContext(null), this.readQName));
    }

    public void testSubject() throws Exception {
        Subject callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER2));
        LocalConfigPDP pdp = new LocalConfigPDP();
        pdp.initialize((PDPConfig)this.resourceConfig, this.PDP_NAME, "dummyService");
        TestLocalConfig.assertTrue((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), this.readQName));
        TestLocalConfig.assertFalse((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), this.writeQName));
        callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER3));
        TestLocalConfig.assertFalse((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), this.writeQName));
        callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        TestLocalConfig.assertTrue((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), this.execQName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

