/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.security.Principal;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.impl.security.authorization.GridMapAuthorization;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.jndi.JNDIUtils;

public class TestGridMapAuthorization
extends TestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$TestGridMapAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$TestGridMapAuthorization = TestGridMapAuthorization.class$("org.globus.wsrf.impl.security.authorization.TestGridMapAuthorization")) : class$org$globus$wsrf$impl$security$authorization$TestGridMapAuthorization).getName());
    private Subject anonSubject = new Subject();
    private String USER1 = "/CN=foo";
    private String USER2 = "/CN=bar";
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$TestGridMapAuthorization;

    public TestGridMapAuthorization(String name) throws Exception {
        super(name);
        Context initialContext = JNDIUtils.initJNDI();
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authorization$TestGridMapAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$TestGridMapAuthorization = TestGridMapAuthorization.class$("org.globus.wsrf.impl.security.authorization.TestGridMapAuthorization")) : class$org$globus$wsrf$impl$security$authorization$TestGridMapAuthorization);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGridMapAuthorization.suite());
    }

    public void testAnonymous() throws Exception {
        GridMapAuthorization pdp = GridMapAuthorization.getInstance();
        String servicePath = "service1";
        GridMap map = new GridMap();
        map.map(this.USER2, "nobody");
        this.storeServiceGridMap(servicePath, map);
        boolean exp = false;
        try {
            pdp.initialize(null, null, servicePath);
            pdp.isPermitted(this.anonSubject, (MessageContext)new org.apache.axis.MessageContext(null), null);
            TestGridMapAuthorization.fail((String)"Failed to throw exception");
        }
        catch (AuthorizationException e) {
            if (e.getMessage().indexOf("anonymous") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        TestGridMapAuthorization.assertTrue((boolean)exp);
    }

    public void testFail() throws Exception {
        GridMapAuthorization pdp = GridMapAuthorization.getInstance();
        String servicePath = "service2";
        GridMap map = new GridMap();
        map.map(this.USER2, "nobody");
        this.storeServiceGridMap(servicePath, map);
        Subject callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        pdp.initialize(null, null, servicePath);
        TestGridMapAuthorization.assertFalse((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), null));
    }

    public void testSuccess() throws Exception {
        GridMapAuthorization pdp = GridMapAuthorization.getInstance();
        String servicePath = "service3";
        GridMap map = new GridMap();
        map.map(this.USER2, "nobody");
        map.map(this.USER1, "nobody");
        this.storeServiceGridMap(servicePath, map);
        Subject callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        pdp.initialize(null, null, servicePath);
        TestGridMapAuthorization.assertTrue((boolean)pdp.isPermitted(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), null));
    }

    private void storeServiceGridMap(String servicePath, GridMap map) throws Exception {
        ServiceSecurityConfig.initialize((String)servicePath, null);
        ServiceSecurityConfig.setGridMap((GridMap)map, (String)servicePath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

