/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import java.io.ByteArrayInputStream;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureException;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.wsrf.impl.security.authentication.VerifyWSSecurity;
import org.globus.wsrf.impl.security.authentication.signature.GssSignedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TestGssXMLSignature
extends TestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$TestGssXMLSignature == null ? (class$org$globus$wsrf$impl$security$authentication$TestGssXMLSignature = TestGssXMLSignature.class$("org.globus.wsrf.impl.security.authentication.TestGssXMLSignature")) : class$org$globus$wsrf$impl$security$authentication$TestGssXMLSignature).getName());
    GSSContext clientContext;
    GSSContext serverContext;
    org.apache.axis.MessageContext msgContext;
    static final String NS = "http://www.w3.org/2000/09/xmldsig#";
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n<SOAP-ENV:Body>\r\n<add xmlns=\"http://samples.wsrf.globus.org/counter/counter_port_type\">\r\n<value xmlns=\"\">15</value>\r\n</add>\r\n</SOAP-ENV:Body>\r\n</SOAP-ENV:Envelope>";
    org.apache.axis.message.SOAPEnvelope unsignedEnvelope;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$TestGssXMLSignature;

    public TestGssXMLSignature(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authentication$TestGssXMLSignature == null ? (class$org$globus$wsrf$impl$security$authentication$TestGssXMLSignature = TestGssXMLSignature.class$("org.globus.wsrf.impl.security.authentication.TestGssXMLSignature")) : class$org$globus$wsrf$impl$security$authentication$TestGssXMLSignature);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGssXMLSignature.suite());
    }

    protected void setUp() throws Exception {
        this.createContexts();
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new org.apache.axis.MessageContext((AxisEngine)tmpEngine);
        this.unsignedEnvelope = this.getSOAPEnvelope();
    }

    protected org.apache.axis.message.SOAPEnvelope getSOAPEnvelope() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg.getSOAPEnvelope();
    }

    protected void createContexts() throws Exception {
        GSSManager manager = ExtendedGSSManager.getInstance();
        this.serverContext = manager.createContext((GSSCredential)null);
        this.clientContext = manager.createContext(null, GSSConstants.MECH_OID, null, 0);
        this.clientContext.requestConf(false);
        this.clientContext.requestCredDeleg(false);
    }

    protected void tearDown() throws Exception {
        if (this.clientContext != null) {
            this.clientContext.dispose();
        }
        if (this.serverContext != null) {
            this.serverContext.dispose();
        }
    }

    private void establishContext() throws Exception {
        TestGssXMLSignature.assertTrue((String)"client ctx already established.", (!this.clientContext.isEstablished() ? 1 : 0) != 0);
        TestGssXMLSignature.assertTrue((String)"server ctx already established.", (!this.serverContext.isEstablished() ? 1 : 0) != 0);
        byte[] inToken = new byte[]{};
        byte[] outToken = null;
        while (!this.clientContext.isEstablished()) {
            outToken = this.clientContext.initSecContext(inToken, 0, inToken.length);
            if (outToken == null) continue;
            inToken = this.serverContext.acceptSecContext(outToken, 0, outToken.length);
        }
        TestGssXMLSignature.assertTrue((String)"client ctx not established.", (boolean)this.clientContext.isEstablished());
        TestGssXMLSignature.assertTrue((String)"server ctx not established.", (boolean)this.serverContext.isEstablished());
    }

    public void testSuccessfulVerify() throws Exception {
        this.establishContext();
        GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        org.apache.axis.message.SOAPEnvelope signedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelope);
        this.verify(signedEnvelope, this.serverContext);
    }

    public void testRemoveBodyVerify() throws Exception {
        this.establishContext();
        GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        org.apache.axis.message.SOAPEnvelope signedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelope);
        SOAPBodyElement el = signedEnvelope.getFirstBody();
        signedEnvelope.removeBodyElement(el);
        try {
            this.verify(signedEnvelope, this.serverContext);
            TestGssXMLSignature.fail((String)"Signature verification did not fail as expected.");
        }
        catch (WSSecurityException e) {
            logger.debug((Object)e);
        }
    }

    public void testChangeBodyVerify() throws Exception {
        this.establishContext();
        GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        org.apache.axis.message.SOAPEnvelope signedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelope);
        SOAPBodyElement el = signedEnvelope.getFirstBody();
        signedEnvelope.removeBodyElement(el);
        Element newEl = el.getAsDOM();
        Text text = (Text)newEl.getElementsByTagName("value").item(0).getFirstChild();
        text.setData("16");
        SOAPBodyElement ee = new SOAPBodyElement(newEl);
        signedEnvelope.addBodyElement(ee);
        try {
            this.verify(signedEnvelope, this.serverContext);
            TestGssXMLSignature.fail((String)"Signature verification did not fail as expected.");
        }
        catch (WSSecurityException e) {
            logger.debug((Object)e);
        }
    }

    public void testChangeDigest() throws Exception {
        this.establishContext();
        GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        org.apache.axis.message.SOAPEnvelope signedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelope);
        SOAPHeaderElement header = (SOAPHeaderElement)signedEnvelope.getHeaders().elementAt(0);
        signedEnvelope.removeHeader(header);
        Element headerElement = header.getAsDOM();
        Node digestValue = ((Element)headerElement.getFirstChild()).getElementsByTagNameNS(NS, "DigestValue").item(0);
        Text digest = (Text)digestValue.getFirstChild();
        String data = digest.getData();
        int half = data.length() / 2;
        StringBuffer buf = new StringBuffer(data.length());
        buf.append(data.substring(0, half));
        buf.append(data.charAt(half) == '6' ? "7" : "6");
        buf.append(data.substring(half + 1));
        digest.setData(buf.toString());
        signedEnvelope.addHeader(new SOAPHeaderElement(headerElement));
        try {
            this.verify(signedEnvelope, this.serverContext);
            TestGssXMLSignature.fail((String)"Signature verification did not fail as expected.");
        }
        catch (WSSecurityException e) {
            logger.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVerifyWithWrongContext() throws Exception {
        this.establishContext();
        GSSContext pClientContext = this.clientContext;
        GSSContext pServerContext = this.serverContext;
        this.createContexts();
        this.establishContext();
        GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        org.apache.axis.message.SOAPEnvelope signedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelope);
        try {
            this.verify(signedEnvelope, pServerContext);
            TestGssXMLSignature.fail((String)"Signature verification did not fail as expected.");
        }
        catch (XMLSignatureException e) {
            logger.debug((Object)e);
        }
        finally {
            try {
                pClientContext.dispose();
            }
            catch (Exception e) {}
            try {
                pServerContext.dispose();
            }
            catch (Exception e) {}
        }
    }

    private void verify(org.apache.axis.message.SOAPEnvelope env, GSSContext context) throws Exception {
        VerifyWSSecurity h = new VerifyWSSecurity(context);
        Document doc = h.processSecurityHeader((SOAPEnvelope)env, "", (MessageContext)this.msgContext, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GSSConfig.init();
    }
}

