/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import java.io.ByteArrayInputStream;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.wsrf.impl.security.authentication.VerifyWSSecurity;
import org.globus.wsrf.impl.security.authentication.encryption.GssEncryptedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class TestGssXMLEncryption
extends TestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$TestGssXMLEncryption == null ? (class$org$globus$wsrf$impl$security$authentication$TestGssXMLEncryption = TestGssXMLEncryption.class$("org.globus.wsrf.impl.security.authentication.TestGssXMLEncryption")) : class$org$globus$wsrf$impl$security$authentication$TestGssXMLEncryption).getName());
    SecurityContext clientContext;
    SecurityContext serverContext;
    org.apache.axis.MessageContext msgContext;
    static final String NS = "http://www.w3.org/2000/09/xmldsig#";
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n<SOAP-ENV:Body>\r\n<add xmlns=\"http://samples.wsrf.globus.org/counter/counter_port_type\">\r\n<value xmlns=\"\">15</value>\r\n</add>\r\n</SOAP-ENV:Body>\r\n</SOAP-ENV:Envelope>";
    org.apache.axis.message.SOAPEnvelope clearEnvelope;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$TestGssXMLEncryption;

    public TestGssXMLEncryption(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authentication$TestGssXMLEncryption == null ? (class$org$globus$wsrf$impl$security$authentication$TestGssXMLEncryption = TestGssXMLEncryption.class$("org.globus.wsrf.impl.security.authentication.TestGssXMLEncryption")) : class$org$globus$wsrf$impl$security$authentication$TestGssXMLEncryption);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGssXMLEncryption.suite());
    }

    protected void setUp() throws Exception {
        this.createContexts();
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new org.apache.axis.MessageContext((AxisEngine)tmpEngine);
        this.clearEnvelope = this.getSOAPEnvelope();
    }

    protected org.apache.axis.message.SOAPEnvelope getSOAPEnvelope() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg.getSOAPEnvelope();
    }

    protected void createContexts() throws Exception {
        GSSManager manager = ExtendedGSSManager.getInstance();
        GSSContext context = manager.createContext((GSSCredential)null);
        String id = "" + context.hashCode();
        this.serverContext = new SecurityContext(context, id);
        context = manager.createContext(null, GSSConstants.MECH_OID, null, 0);
        this.clientContext = new SecurityContext(context, id);
        this.clientContext.getContext().requestConf(false);
        this.clientContext.getContext().requestCredDeleg(false);
    }

    protected void tearDown() throws Exception {
        if (this.clientContext != null) {
            this.clientContext.getContext().dispose();
        }
        if (this.serverContext != null) {
            this.serverContext.getContext().dispose();
        }
    }

    private void establishContext() throws Exception {
        TestGssXMLEncryption.assertTrue((String)"client ctx already established.", (!this.clientContext.getContext().isEstablished() ? 1 : 0) != 0);
        TestGssXMLEncryption.assertTrue((String)"server ctx already established.", (!this.serverContext.getContext().isEstablished() ? 1 : 0) != 0);
        byte[] inToken = new byte[]{};
        byte[] outToken = null;
        while (!this.clientContext.getContext().isEstablished()) {
            outToken = this.clientContext.getContext().initSecContext(inToken, 0, inToken.length);
            if (outToken == null) continue;
            inToken = this.serverContext.getContext().acceptSecContext(outToken, 0, outToken.length);
        }
        TestGssXMLEncryption.assertTrue((String)"client ctx not established.", (boolean)this.clientContext.getContext().isEstablished());
        TestGssXMLEncryption.assertTrue((String)"server ctx not established.", (boolean)this.serverContext.getContext().isEstablished());
    }

    public void testSuccessfulDecrypt() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope encryptedEnvelope = null;
        GssEncryptedSOAPEnvelopeBuilder builder = new GssEncryptedSOAPEnvelopeBuilder(null, this.clientContext);
        encryptedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.clearEnvelope);
        this.decrypt(encryptedEnvelope, this.serverContext);
    }

    public void testRemoveBodyDecrypt() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope encryptedEnvelope = null;
        GssEncryptedSOAPEnvelopeBuilder builder = new GssEncryptedSOAPEnvelopeBuilder(null, this.clientContext);
        encryptedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.clearEnvelope);
        SOAPBodyElement el = encryptedEnvelope.getFirstBody();
        encryptedEnvelope.removeBodyElement(el);
        try {
            this.decrypt(encryptedEnvelope, this.serverContext);
            TestGssXMLEncryption.fail((String)"Encryption verification did not fail as expected.");
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testDecryptWithWrongContext() throws Exception {
        block14: {
            this.establishContext();
            SecurityContext pClientContext = this.clientContext;
            SecurityContext pServerContext = this.serverContext;
            this.createContexts();
            this.establishContext();
            org.apache.axis.message.SOAPEnvelope encryptedEnvelope = null;
            GssEncryptedSOAPEnvelopeBuilder builder = new GssEncryptedSOAPEnvelopeBuilder(null, this.clientContext);
            encryptedEnvelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.clearEnvelope);
            this.decrypt(encryptedEnvelope, pServerContext);
            TestGssXMLEncryption.fail((String)"Encryption verification did not fail as expected.");
            Object var7_5 = null;
            try {
                pClientContext.getContext().dispose();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                pServerContext.getContext().dispose();
            }
            catch (Exception e2) {}
            break block14;
            {
                catch (Exception e) {
                    logger.debug((Object)e);
                    Object var7_6 = null;
                    try {
                        pClientContext.getContext().dispose();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        pServerContext.getContext().dispose();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    pClientContext.getContext().dispose();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    pServerContext.getContext().dispose();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void decrypt(org.apache.axis.message.SOAPEnvelope env, SecurityContext context) throws Exception {
        VerifyWSSecurity h = new VerifyWSSecurity(context.getContext());
        this.msgContext.setProperty("org.globus.security.secureconv.context", (Object)context);
        h.processSecurityHeader((SOAPEnvelope)env, "", (MessageContext)this.msgContext, false);
        this.msgContext.setProperty("org.globus.security.secureconv.context", null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GSSConfig.init();
    }
}

