/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.impl.security.SecurityTestResource;
import org.globus.wsrf.impl.security.SecurityTestResourceHome;
import org.globus.wsrf.impl.security.authorization.ServicePropertiesPDPConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.TestContainerSecurityConfig;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.impl.security.util.PDPUtils;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.globus.wsrf.tests.security.CreateResourceResponse;
import org.globus.wsrf.tests.security.GetValue;
import org.globus.wsrf.tests.security.GsiSec;
import org.globus.wsrf.tests.security.GsiSecConvDeleg;
import org.globus.wsrf.tests.security.GsiSecConvIntegrity;
import org.globus.wsrf.tests.security.GsiSecConvOnly;
import org.globus.wsrf.tests.security.GsiSecConvPrivacy;
import org.globus.wsrf.tests.security.GsiSecMsgIntegrity;
import org.globus.wsrf.tests.security.GsiSecMsgOnly;
import org.globus.wsrf.tests.security.GsiSecMsgPrivacy;
import org.globus.wsrf.tests.security.GsiTransportIntegrity;
import org.globus.wsrf.tests.security.GsiTransportOnly;
import org.globus.wsrf.tests.security.GsiTransportPrivacy;
import org.globus.wsrf.tests.security.NoAuthRequest;
import org.globus.wsrf.tests.security.SetAnonymousAuthz;
import org.globus.wsrf.tests.security.SetAnonymousAuthzResponse;
import org.globus.wsrf.tests.security.SetServiceAuthzOutput;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.ContextUtils;

public class SecurityTestService {
    public static final String CRED_FROM_CONTEXT = "credFromContext";
    private static final String CONTAINER_DESC = "org/globus/wsrf/impl/security/container-security-config.xml";
    public static final String CUSTOM_AUTHZ_TEST = "customAuthzTest";
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$SecurityTestService == null ? (class$org$globus$wsrf$impl$security$SecurityTestService = SecurityTestService.class$("org.globus.wsrf.impl.security.SecurityTestService")) : class$org$globus$wsrf$impl$security$SecurityTestService).getName());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$SecurityTestService;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout;

    public void noAuth(NoAuthRequest noAuthRequest) throws RemoteException {
        logger.debug((Object)"No Auth");
        MessageContext msgCtx = MessageContext.getCurrentContext();
        String customAuthTest = (String)ContextUtils.getServiceProperty((MessageContext)msgCtx, (String)CUSTOM_AUTHZ_TEST);
        if (customAuthTest != null && customAuthTest.equals("true")) {
            logger.debug((Object)"reworking security settings");
            String authzService = noAuthRequest.getAuthzService();
            String authzServiceIdentity = noAuthRequest.getAuthzServiceIdentity();
            SecurityManager manager = SecurityManager.getManager((SOAPMessageContext)msgCtx);
            Subject systemSubject = manager.getSystemSubject();
            GlobusGSSCredentialImpl credential = (GlobusGSSCredentialImpl)JaasGssUtil.getCredential((Subject)systemSubject);
            X509Certificate authzServiceCert = credential.getCertificateChain()[0];
            try {
                if (authzService == null) {
                    authzService = ServiceHost.getBaseURL((MessageContext)msgCtx) + "TestAuthzService";
                }
            }
            catch (IOException exp) {
                throw new RemoteException("", exp);
            }
            logger.debug((Object)ContextUtils.getTargetServicePath((MessageContext)msgCtx));
            String servicePath = ContextUtils.getTargetServicePath((MessageContext)msgCtx);
            String pdpChain = AuthUtil.substitutePDPNames((String)"samlCallout");
            pdpChain = pdpChain + " prefix1:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName() + " prefix2:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName() + " prefix3:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName() + " prefix4:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName() + " prefix5:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName() + " prefix6:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName() + " prefix7:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName() + " prefix8:" + (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SecurityTestService.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName();
            ServicePropertiesPDPConfig config = new ServicePropertiesPDPConfig(msgCtx, servicePath, pdpChain);
            this.setSAMLCalloutProperties(config, "samlAuthz", authzService, null, null, null, null, authzServiceIdentity, null);
            this.setSAMLCalloutProperties(config, "prefix1", authzService, "msg", null, null, null, authzServiceIdentity, null);
            this.setSAMLCalloutProperties(config, "prefix2", authzService, "none", null, null, null, authzServiceIdentity, null);
            this.setSAMLCalloutProperties(config, "prefix3", authzService, "conv", "sig", null, null, authzServiceIdentity, null);
            this.setSAMLCalloutProperties(config, "prefix4", authzService, null, "enc", null, null, authzServiceIdentity, null);
            this.setSAMLCalloutProperties(config, "prefix5", authzService, "msg", "enc", null, null, authzServiceIdentity, authzServiceCert);
            this.setSAMLCalloutProperties(config, "prefix6", authzService, null, null, null, "true", authzServiceIdentity, authzServiceCert);
            this.setSAMLCalloutProperties(config, "prefix7", authzService, "msg", null, null, "true", authzServiceIdentity, authzServiceCert);
            this.setSAMLCalloutProperties(config, "prefix8", authzService, null, null, "false", "true", authzServiceIdentity, authzServiceCert);
            logger.debug((Object)("Authz service set to " + authzService));
            try {
                ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor((String)servicePath);
                desc.setAuthzChain(PDPUtils.getServiceAuthzChain((PDPConfig)config, (String)"SecurityTestService"));
                ServiceSecurityConfig.setSecurityDescriptor((ServiceSecurityDescriptor)desc, (String)servicePath);
            }
            catch (ConfigException exp) {
                throw new RemoteException("", exp);
            }
        }
    }

    private void setSAMLCalloutProperties(ServicePropertiesPDPConfig config, String prefix, String authzService, String securityMechanism, String protectionLevel, String simpleDecision, String reqSigned, String serviceIdentity, X509Certificate serviceCert) {
        config.setProperty(prefix, "authzService", (Object)authzService);
        config.setProperty(prefix, "securityMechanism", (Object)securityMechanism);
        config.setProperty(prefix, "protectionLevel", (Object)protectionLevel);
        config.setProperty(prefix, "samlAuthzSimpleDecision", (Object)simpleDecision);
        config.setProperty(prefix, "samlAuthzReqSigned", (Object)reqSigned);
        config.setProperty(prefix, "authzServiceIdentity", (Object)serviceIdentity);
        config.setProperty(prefix, "authzServiceCertificate", (Object)serviceCert);
    }

    public void gsiSecConvDeleg(GsiSecConvDeleg param) throws RemoteException {
        logger.debug((Object)"Sec Conv Deleg");
    }

    public void gsiTransportIntegrity(GsiTransportIntegrity param) throws RemoteException {
        logger.error((Object)"tansport integrity");
    }

    public void gsiTransportPrivacy(GsiTransportPrivacy param) throws RemoteException {
        logger.error((Object)"transport privacy");
    }

    public void gsiTransportOnly(GsiTransportOnly param) throws RemoteException {
        logger.error((Object)"transport only");
    }

    public void gsiSecConvIntegrity(GsiSecConvIntegrity param) throws RemoteException {
        logger.debug((Object)"Sec Conv integrity");
    }

    public void gsiSecConvPrivacy(GsiSecConvPrivacy param) throws RemoteException {
        logger.debug((Object)"Sec Conv privacy");
    }

    public void gsiSecConvOnly(GsiSecConvOnly param) throws RemoteException {
        logger.debug((Object)"sec conv only");
    }

    public void gsiSecMsgOnly(GsiSecMsgOnly param) throws RemoteException {
        logger.debug((Object)"sec msg only");
    }

    public void gsiSecMsgPrivacy(GsiSecMsgPrivacy param) throws RemoteException {
        logger.debug((Object)"sec msg privacy only");
    }

    public void gsiSecMsgIntegrity(GsiSecMsgIntegrity param) throws RemoteException {
        logger.debug((Object)"sec msg integrity only");
    }

    public void gsiSec(GsiSec param) throws RemoteException {
        logger.debug((Object)"any gsi sec only");
    }

    public CreateResourceResponse createResource(boolean param) throws RemoteException {
        if (param) {
            try {
                TestContainerSecurityConfig.initContainerConfig(CONTAINER_DESC);
                ContainerSecurityConfig containerConfig = ContainerSecurityConfig.getConfig();
            }
            catch (Exception exp) {
                throw new RemoteException("", exp);
            }
        }
        ResourceContext ctx = null;
        SecurityTestResourceHome home = null;
        ResourceKey key = null;
        try {
            ctx = ResourceContext.getResourceContext();
            home = (SecurityTestResourceHome)ctx.getResourceHome();
            key = home.create();
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
        EndpointReferenceType epr = null;
        try {
            epr = AddressingUtils.createEndpointReference((ResourceContext)ctx, (ResourceKey)key);
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
        CreateResourceResponse response = new CreateResourceResponse();
        response.setEndpointReference(epr);
        return response;
    }

    public void alterSecurityDesc(String authMethodName) throws RemoteException {
        logger.debug((Object)("Alter security desc " + authMethodName));
        if (authMethodName != null && authMethodName.equals(CRED_FROM_CONTEXT)) {
            Subject sub = null;
            try {
                sub = ServiceSecurityConfig.getSubject((String)"SecurityTestService");
            }
            catch (ConfigException exp) {
                throw new RemoteException("Error getting subject", exp);
            }
            if (sub != null) {
                throw new RemoteException("Inital subject is not null");
            }
            SecurityManager man = SecurityManager.getManager();
            man.setServiceOwnerFromContext();
            Subject invokedSub = man.getServiceSubject();
            if (invokedSub == null) {
                throw new RemoteException("Invoked subject is null");
            }
            logger.debug((Object)("Invoked subject" + invokedSub));
            logger.debug((Object)"Now test resource");
            SecurityTestResource res = this.getResource();
            res.alterSecurityDesc(authMethodName);
            return;
        }
        SecurityTestResource res = this.getResource();
        logger.debug((Object)"invoking alter sec");
        res.alterSecurityDesc(authMethodName);
    }

    public void setAuthz(String authz) throws RemoteException {
        logger.debug((Object)("Alter security desc " + authz));
        SecurityTestResource res = this.getResource();
        try {
            logger.debug((Object)"invoking alter sec");
            res.setAuthz(authz);
        }
        catch (Exception exp) {
            throw new RemoteException("Error setting security desc", exp);
        }
    }

    public SetAnonymousAuthzResponse setAnonymousAuthz(SetAnonymousAuthz setAnonymousAuthz) throws RemoteException {
        logger.debug((Object)"Changing to identity authz with anonymous authorized user");
        SecurityTestResource res = this.getResource();
        try {
            logger.debug((Object)"invoking alter sec");
            res.setAnonymousAuthz();
        }
        catch (Exception exp) {
            throw new RemoteException("Error setting security desc", exp);
        }
        return new SetAnonymousAuthzResponse();
    }

    public void setValue(int val) throws RemoteException {
        logger.debug((Object)("Set value " + val));
        SecurityTestResource res = this.getResource();
        res.setValue(val);
    }

    public int getValue(GetValue param) throws RemoteException {
        logger.debug((Object)"Get value ");
        SecurityTestResource res = this.getResource();
        return res.getValue();
    }

    public String getSecurityProperty(String argName) throws RemoteException {
        String value = null;
        try {
            if (argName.equals("replayWindow")) {
                value = SecurityPropertiesHelper.getReplayAttackWindow((String)"SecurityTestService", null);
            } else if (argName.equals("replayFilter")) {
                value = SecurityPropertiesHelper.getReplayAttackFilter((String)"SecurityTestService", null);
            }
        }
        catch (ConfigException exp) {
            throw new RemoteException("", exp);
        }
        return value;
    }

    public SetServiceAuthzOutput setServiceAuthz(String parameters) throws RemoteException {
        if (parameters != null && parameters.equals("self")) {
            try {
                String prop = (String)ContextUtils.getServiceProperty((MessageContext)MessageContext.getCurrentContext(), (String)"SecurityTestService", (String)"idenAuthz-identity");
                if (prop != null && parameters != null) {
                    parameters = "identity";
                }
            }
            catch (Exception exp) {
                throw new RemoteException("", exp);
            }
        }
        System.out.println("CHECK THIS " + parameters);
        try {
            ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor((String)"SecurityTestService");
            desc.setAuthzChain(PDPUtils.getServiceAuthzChain((String)parameters, (String)"SecurityTestService"));
            if (parameters != null && parameters.equals("gridmap")) {
                GridMap gridMap = new GridMap();
                gridMap.map("Some DN", "some id");
                desc.setGridMap(gridMap);
            }
            ServiceSecurityConfig.setSecurityDescriptor((ServiceSecurityDescriptor)desc, (String)"SecurityTestService");
        }
        catch (ConfigException exp) {
            throw new RemoteException("", exp);
        }
        return new SetServiceAuthzOutput();
    }

    private SecurityTestResource getResource() throws RemoteException {
        Resource obj = null;
        try {
            obj = ResourceContext.getResourceContext().getResource();
        }
        catch (Exception e) {
            throw new RemoteException("Error getting resource", e);
        }
        if (obj == null) {
            logger.debug((Object)"Resource is null");
            throw new RemoteException("bad key set, resource not found");
        }
        return (SecurityTestResource)obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

