/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.ResourcePropertyTopic;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.SimpleTopicList;
import org.globus.wsrf.impl.security.authorization.ResourcePDPConfig;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.GSISecureConvAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.NoneAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.util.PDPUtils;
import org.globus.wsrf.security.SecureResource;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.globus.wsrf.utils.ContextUtils;

public class SecurityTestResource
implements SecureResource,
Resource,
ResourceProperties,
TopicListAccessor {
    ResourceSecurityDescriptor desc = null;
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$SecurityTestResource == null ? (class$org$globus$wsrf$impl$security$SecurityTestResource = SecurityTestResource.class$("org.globus.wsrf.impl.security.SecurityTestResource")) : class$org$globus$wsrf$impl$security$SecurityTestResource).getName());
    public static final QName RP_SET = new QName("http://security.test", "TestRP");
    public static final QName VALUE = new QName("http://security.test", "Value");
    private ResourcePropertySet propSet = new SimpleResourcePropertySet(RP_SET);
    private TopicList topicList = new SimpleTopicList((ResourceProperties)this);
    protected ResourceProperty value;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$SecurityTestResource;

    public SecurityTestResource() {
        try {
            this.value = new ResourcePropertyTopic((ResourceProperty)new SimpleResourceProperty(VALUE));
            this.propSet.add(this.value);
            this.topicList.addTopic((Topic)this.value);
            this.value.add((Object)new Integer(0));
        }
        catch (Exception exp) {
            throw new RuntimeException(exp.getMessage());
        }
    }

    public TopicList getTopicList() {
        return this.topicList;
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    public void setValue(int value) {
        this.value.set(0, (Object)new Integer(value));
    }

    public int getValue() {
        return (Integer)this.value.get(0);
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        if (this.desc != null) {
            logger.debug((Object)("Authz at get is " + this.desc.getAuthz()));
        } else {
            logger.debug((Object)"Authz is null");
        }
        return this.desc;
    }

    public void alterSecurityDesc(String authType) throws RemoteException {
        logger.debug((Object)("Called " + authType));
        if (authType == null) {
            logger.debug((Object)"Auth type is null");
            this.desc = null;
            return;
        }
        if (authType.equals("credFromContext")) {
            Subject sub;
            if (this.desc == null) {
                this.desc = new ResourceSecurityDescriptor();
            }
            if ((sub = this.desc.getSubject()) != null) {
                throw new RemoteException("Initial subject is not null");
            }
            SecurityManager man = SecurityManager.getManager();
            try {
                man.setResourceOwnerFromContext(this.desc);
            }
            catch (Exception exp) {
                throw new RemoteException("error setting owner", exp);
            }
            logger.error((Object)("Subject " + this.desc.getSubject()));
            if (this.desc.getSubject() == null) {
                throw new RemoteException("Subject null after set from context");
            }
        }
        Vector<Object> authMethods = new Vector<Object>();
        logger.debug((Object)("Auth type is " + authType));
        if (this.desc == null) {
            this.desc = new ResourceSecurityDescriptor();
        }
        if (authType.equals("GSISecureConv")) {
            authMethods.add(GSISecureConvAuthMethod.BOTH);
        } else if (authType.equals("GSISecureMsg")) {
            authMethods.add(GSISecureMsgAuthMethod.BOTH);
        } else if (authType.equals("None")) {
            authMethods.add(NoneAuthMethod.getInstance());
        } else {
            return;
        }
        try {
            this.desc.setAuthMethods(authMethods, true);
        }
        catch (Exception exp) {
            throw new RemoteException("error altering sec desc", exp);
        }
        logger.debug((Object)"Altered");
    }

    public void setAuthz(String authz) throws SecurityDescriptorException {
        logger.debug((Object)("Called " + authz));
        if (authz == null) {
            logger.debug((Object)"Auth type is null");
            this.desc = null;
            return;
        }
        if (this.desc == null) {
            this.desc = new ResourceSecurityDescriptor();
        }
        try {
            String prop = (String)ContextUtils.getServiceProperty((MessageContext)MessageContext.getCurrentContext(), (String)"SecurityTestService", (String)"idenAuthz-identity");
            if (prop != null && !authz.equals("none")) {
                ResourcePDPConfig config = new ResourcePDPConfig("identity");
                config.setProperty("idenAuthz", "identity", (Object)prop);
                ServiceAuthorizationChain chain = PDPUtils.getServiceAuthzChain((PDPConfig)config, (String)"some id");
                this.desc.setAuthzChain(chain);
            } else {
                this.desc.setAuthz(authz);
                this.desc.setInitialized(false);
            }
        }
        catch (Exception exp) {
            throw new SecurityDescriptorException("", exp);
        }
        logger.debug((Object)("Authz is set to " + this.desc.getAuthz()));
    }

    public void setAnonymousAuthz() throws SecurityDescriptorException, ConfigException {
        if (this.desc == null) {
            this.desc = new ResourceSecurityDescriptor();
        }
        this.desc.setInitialized(false);
        Vector<GSITransportAuthMethod> authMethod = new Vector<GSITransportAuthMethod>();
        authMethod.add(GSITransportAuthMethod.BOTH);
        this.desc.setAuthMethods(authMethod);
        this.desc.setAuthz("gridmap");
        GridMap map = new GridMap();
        map.map("<anonymous>", "userid");
        this.desc.setGridMap(map);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

